<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceAlarmMessageResult StructType
 * @subpackage Structs
 */
class InterfaceAlarmMessageResult extends AbstractStructBase
{
    /**
     * The AlarmMessageTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AlarmMessageTransicsID;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AlarmMessageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmMessageType;
    /**
     * Constructor method for InterfaceAlarmMessageResult
     * @uses InterfaceAlarmMessageResult::setAlarmMessageTransicsID()
     * @uses InterfaceAlarmMessageResult::setCreationDate()
     * @uses InterfaceAlarmMessageResult::setMessage()
     * @uses InterfaceAlarmMessageResult::setAlarmMessageType()
     * @param int $alarmMessageTransicsID
     * @param string $creationDate
     * @param string $message
     * @param string $alarmMessageType
     */
    public function __construct($alarmMessageTransicsID = null, $creationDate = null, $message = null, $alarmMessageType = null)
    {
        $this
            ->setAlarmMessageTransicsID($alarmMessageTransicsID)
            ->setCreationDate($creationDate)
            ->setMessage($message)
            ->setAlarmMessageType($alarmMessageType);
    }
    /**
     * Get AlarmMessageTransicsID value
     * @return int
     */
    public function getAlarmMessageTransicsID()
    {
        return $this->AlarmMessageTransicsID;
    }
    /**
     * Set AlarmMessageTransicsID value
     * @param int $alarmMessageTransicsID
     * @return \StructType\InterfaceAlarmMessageResult
     */
    public function setAlarmMessageTransicsID($alarmMessageTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmMessageTransicsID) && !(is_int($alarmMessageTransicsID) || ctype_digit($alarmMessageTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmMessageTransicsID, true), gettype($alarmMessageTransicsID)), __LINE__);
        }
        $this->AlarmMessageTransicsID = $alarmMessageTransicsID;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\InterfaceAlarmMessageResult
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\InterfaceAlarmMessageResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AlarmMessageType value
     * @return string|null
     */
    public function getAlarmMessageType()
    {
        return $this->AlarmMessageType;
    }
    /**
     * Set AlarmMessageType value
     * @param string $alarmMessageType
     * @return \StructType\InterfaceAlarmMessageResult
     */
    public function setAlarmMessageType($alarmMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($alarmMessageType) && !is_string($alarmMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alarmMessageType, true), gettype($alarmMessageType)), __LINE__);
        }
        $this->AlarmMessageType = $alarmMessageType;
        return $this;
    }
}
