<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboxInfo StructType
 * @subpackage Structs
 */
class InboxInfo extends AbstractStructBase
{
    /**
     * The TotalMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalMessages;
    /**
     * The ReadMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReadMessages;
    /**
     * The UnreadMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnreadMessages;
    /**
     * The TreatedMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TreatedMessages;
    /**
     * The UntreatedMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UntreatedMessages;
    /**
     * Constructor method for InboxInfo
     * @uses InboxInfo::setTotalMessages()
     * @uses InboxInfo::setReadMessages()
     * @uses InboxInfo::setUnreadMessages()
     * @uses InboxInfo::setTreatedMessages()
     * @uses InboxInfo::setUntreatedMessages()
     * @param int $totalMessages
     * @param int $readMessages
     * @param int $unreadMessages
     * @param int $treatedMessages
     * @param int $untreatedMessages
     */
    public function __construct($totalMessages = null, $readMessages = null, $unreadMessages = null, $treatedMessages = null, $untreatedMessages = null)
    {
        $this
            ->setTotalMessages($totalMessages)
            ->setReadMessages($readMessages)
            ->setUnreadMessages($unreadMessages)
            ->setTreatedMessages($treatedMessages)
            ->setUntreatedMessages($untreatedMessages);
    }
    /**
     * Get TotalMessages value
     * @return int
     */
    public function getTotalMessages()
    {
        return $this->TotalMessages;
    }
    /**
     * Set TotalMessages value
     * @param int $totalMessages
     * @return \StructType\InboxInfo
     */
    public function setTotalMessages($totalMessages = null)
    {
        // validation for constraint: int
        if (!is_null($totalMessages) && !(is_int($totalMessages) || ctype_digit($totalMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMessages, true), gettype($totalMessages)), __LINE__);
        }
        $this->TotalMessages = $totalMessages;
        return $this;
    }
    /**
     * Get ReadMessages value
     * @return int
     */
    public function getReadMessages()
    {
        return $this->ReadMessages;
    }
    /**
     * Set ReadMessages value
     * @param int $readMessages
     * @return \StructType\InboxInfo
     */
    public function setReadMessages($readMessages = null)
    {
        // validation for constraint: int
        if (!is_null($readMessages) && !(is_int($readMessages) || ctype_digit($readMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readMessages, true), gettype($readMessages)), __LINE__);
        }
        $this->ReadMessages = $readMessages;
        return $this;
    }
    /**
     * Get UnreadMessages value
     * @return int
     */
    public function getUnreadMessages()
    {
        return $this->UnreadMessages;
    }
    /**
     * Set UnreadMessages value
     * @param int $unreadMessages
     * @return \StructType\InboxInfo
     */
    public function setUnreadMessages($unreadMessages = null)
    {
        // validation for constraint: int
        if (!is_null($unreadMessages) && !(is_int($unreadMessages) || ctype_digit($unreadMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unreadMessages, true), gettype($unreadMessages)), __LINE__);
        }
        $this->UnreadMessages = $unreadMessages;
        return $this;
    }
    /**
     * Get TreatedMessages value
     * @return int
     */
    public function getTreatedMessages()
    {
        return $this->TreatedMessages;
    }
    /**
     * Set TreatedMessages value
     * @param int $treatedMessages
     * @return \StructType\InboxInfo
     */
    public function setTreatedMessages($treatedMessages = null)
    {
        // validation for constraint: int
        if (!is_null($treatedMessages) && !(is_int($treatedMessages) || ctype_digit($treatedMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($treatedMessages, true), gettype($treatedMessages)), __LINE__);
        }
        $this->TreatedMessages = $treatedMessages;
        return $this;
    }
    /**
     * Get UntreatedMessages value
     * @return int
     */
    public function getUntreatedMessages()
    {
        return $this->UntreatedMessages;
    }
    /**
     * Set UntreatedMessages value
     * @param int $untreatedMessages
     * @return \StructType\InboxInfo
     */
    public function setUntreatedMessages($untreatedMessages = null)
    {
        // validation for constraint: int
        if (!is_null($untreatedMessages) && !(is_int($untreatedMessages) || ctype_digit($untreatedMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($untreatedMessages, true), gettype($untreatedMessages)), __LINE__);
        }
        $this->UntreatedMessages = $untreatedMessages;
        return $this;
    }
}
