<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierVehicleGeoFenceResult StructType
 * @subpackage Structs
 */
class IdentifierVehicleGeoFenceResult extends IdentifierVehicleResult
{
    /**
     * The GeoFenceTransferStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $GeoFenceTransferStatus;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for IdentifierVehicleGeoFenceResult
     * @uses IdentifierVehicleGeoFenceResult::setGeoFenceTransferStatus()
     * @uses IdentifierVehicleGeoFenceResult::setActive()
     * @param string $geoFenceTransferStatus
     * @param bool $active
     */
    public function __construct($geoFenceTransferStatus = null, $active = null)
    {
        $this
            ->setGeoFenceTransferStatus($geoFenceTransferStatus)
            ->setActive($active);
    }
    /**
     * Get GeoFenceTransferStatus value
     * @return string
     */
    public function getGeoFenceTransferStatus()
    {
        return $this->GeoFenceTransferStatus;
    }
    /**
     * Set GeoFenceTransferStatus value
     * @uses \EnumType\EnumGeoFenceTransferStatus::valueIsValid()
     * @uses \EnumType\EnumGeoFenceTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoFenceTransferStatus
     * @return \StructType\IdentifierVehicleGeoFenceResult
     */
    public function setGeoFenceTransferStatus($geoFenceTransferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFenceTransferStatus::valueIsValid($geoFenceTransferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGeoFenceTransferStatus', is_array($geoFenceTransferStatus) ? implode(', ', $geoFenceTransferStatus) : var_export($geoFenceTransferStatus, true), implode(', ', \EnumType\EnumGeoFenceTransferStatus::getValidValues())), __LINE__);
        }
        $this->GeoFenceTransferStatus = $geoFenceTransferStatus;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\IdentifierVehicleGeoFenceResult
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
