<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupInsert StructType
 * @subpackage Structs
 */
class GroupInsert extends GroupBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The SubGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSubGroupInsert
     */
    public $SubGroups;
    /**
     * Constructor method for GroupInsert
     * @uses GroupInsert::setType()
     * @uses GroupInsert::setSubGroups()
     * @param string $type
     * @param \ArrayType\ArrayOfSubGroupInsert $subGroups
     */
    public function __construct($type = null, \ArrayType\ArrayOfSubGroupInsert $subGroups = null)
    {
        $this
            ->setType($type)
            ->setSubGroups($subGroups);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\GroupTypeV2::valueIsValid()
     * @uses \EnumType\GroupTypeV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GroupInsert
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupTypeV2::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GroupTypeV2', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\GroupTypeV2::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get SubGroups value
     * @return \ArrayType\ArrayOfSubGroupInsert|null
     */
    public function getSubGroups()
    {
        return $this->SubGroups;
    }
    /**
     * Set SubGroups value
     * @param \ArrayType\ArrayOfSubGroupInsert $subGroups
     * @return \StructType\GroupInsert
     */
    public function setSubGroups(\ArrayType\ArrayOfSubGroupInsert $subGroups = null)
    {
        $this->SubGroups = $subGroups;
        return $this;
    }
}
