<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Drivers_V3 StructType
 * @subpackage Structs
 */
class Get_Drivers_V3 extends AbstractStructBase
{
    /**
     * The ExcludeInactiveDrivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeInactiveDrivers;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Login
     */
    public $Login;
    /**
     * The DriverSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonSelection
     */
    public $DriverSelection;
    /**
     * Constructor method for Get_Drivers_V3
     * @uses Get_Drivers_V3::setExcludeInactiveDrivers()
     * @uses Get_Drivers_V3::setLogin()
     * @uses Get_Drivers_V3::setDriverSelection()
     * @param bool $excludeInactiveDrivers
     * @param \StructType\Login $login
     * @param \StructType\PersonSelection $driverSelection
     */
    public function __construct($excludeInactiveDrivers = null, \StructType\Login $login = null, \StructType\PersonSelection $driverSelection = null)
    {
        $this
            ->setExcludeInactiveDrivers($excludeInactiveDrivers)
            ->setLogin($login)
            ->setDriverSelection($driverSelection);
    }
    /**
     * Get ExcludeInactiveDrivers value
     * @return bool
     */
    public function getExcludeInactiveDrivers()
    {
        return $this->ExcludeInactiveDrivers;
    }
    /**
     * Set ExcludeInactiveDrivers value
     * @param bool $excludeInactiveDrivers
     * @return \StructType\Get_Drivers_V3
     */
    public function setExcludeInactiveDrivers($excludeInactiveDrivers = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeInactiveDrivers) && !is_bool($excludeInactiveDrivers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeInactiveDrivers, true), gettype($excludeInactiveDrivers)), __LINE__);
        }
        $this->ExcludeInactiveDrivers = $excludeInactiveDrivers;
        return $this;
    }
    /**
     * Get Login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\Login $login
     * @return \StructType\Get_Drivers_V3
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get DriverSelection value
     * @return \StructType\PersonSelection|null
     */
    public function getDriverSelection()
    {
        return $this->DriverSelection;
    }
    /**
     * Set DriverSelection value
     * @param \StructType\PersonSelection $driverSelection
     * @return \StructType\Get_Drivers_V3
     */
    public function setDriverSelection(\StructType\PersonSelection $driverSelection = null)
    {
        $this->DriverSelection = $driverSelection;
        return $this;
    }
}
