<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserDetailsResult StructType
 * @subpackage Structs
 */
class GetUserDetailsResult extends AbstractStructBase
{
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Inactive;
    /**
     * The DomainLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $DomainLogin;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The TwoStepAuthentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TwoStepAuthentication;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobTitle;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Emails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Emails;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZone;
    /**
     * The RoleIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $RoleIds;
    /**
     * The TxConnectDispatcherDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TxConnectDispatcherResult
     */
    public $TxConnectDispatcherDetails;
    /**
     * Constructor method for GetUserDetailsResult
     * @uses GetUserDetailsResult::setInactive()
     * @uses GetUserDetailsResult::setDomainLogin()
     * @uses GetUserDetailsResult::setGender()
     * @uses GetUserDetailsResult::setTwoStepAuthentication()
     * @uses GetUserDetailsResult::setUserId()
     * @uses GetUserDetailsResult::setDisplayName()
     * @uses GetUserDetailsResult::setJobTitle()
     * @uses GetUserDetailsResult::setFirstName()
     * @uses GetUserDetailsResult::setMiddleName()
     * @uses GetUserDetailsResult::setLastName()
     * @uses GetUserDetailsResult::setEmails()
     * @uses GetUserDetailsResult::setLanguage()
     * @uses GetUserDetailsResult::setTimeZone()
     * @uses GetUserDetailsResult::setRoleIds()
     * @uses GetUserDetailsResult::setTxConnectDispatcherDetails()
     * @param bool $inactive
     * @param bool $domainLogin
     * @param string $gender
     * @param bool $twoStepAuthentication
     * @param string $userId
     * @param string $displayName
     * @param string $jobTitle
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param \ArrayType\ArrayOfString $emails
     * @param string $language
     * @param string $timeZone
     * @param \ArrayType\ArrayOfString $roleIds
     * @param \StructType\TxConnectDispatcherResult $txConnectDispatcherDetails
     */
    public function __construct($inactive = null, $domainLogin = null, $gender = null, $twoStepAuthentication = null, $userId = null, $displayName = null, $jobTitle = null, $firstName = null, $middleName = null, $lastName = null, \ArrayType\ArrayOfString $emails = null, $language = null, $timeZone = null, \ArrayType\ArrayOfString $roleIds = null, \StructType\TxConnectDispatcherResult $txConnectDispatcherDetails = null)
    {
        $this
            ->setInactive($inactive)
            ->setDomainLogin($domainLogin)
            ->setGender($gender)
            ->setTwoStepAuthentication($twoStepAuthentication)
            ->setUserId($userId)
            ->setDisplayName($displayName)
            ->setJobTitle($jobTitle)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setEmails($emails)
            ->setLanguage($language)
            ->setTimeZone($timeZone)
            ->setRoleIds($roleIds)
            ->setTxConnectDispatcherDetails($txConnectDispatcherDetails);
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\GetUserDetailsResult
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get DomainLogin value
     * @return bool
     */
    public function getDomainLogin()
    {
        return $this->DomainLogin;
    }
    /**
     * Set DomainLogin value
     * @param bool $domainLogin
     * @return \StructType\GetUserDetailsResult
     */
    public function setDomainLogin($domainLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($domainLogin) && !is_bool($domainLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($domainLogin, true), gettype($domainLogin)), __LINE__);
        }
        $this->DomainLogin = $domainLogin;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\EnumSexType::valueIsValid()
     * @uses \EnumType\EnumSexType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\GetUserDetailsResult
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSexType::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSexType', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\EnumSexType::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get TwoStepAuthentication value
     * @return bool
     */
    public function getTwoStepAuthentication()
    {
        return $this->TwoStepAuthentication;
    }
    /**
     * Set TwoStepAuthentication value
     * @param bool $twoStepAuthentication
     * @return \StructType\GetUserDetailsResult
     */
    public function setTwoStepAuthentication($twoStepAuthentication = null)
    {
        // validation for constraint: boolean
        if (!is_null($twoStepAuthentication) && !is_bool($twoStepAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twoStepAuthentication, true), gettype($twoStepAuthentication)), __LINE__);
        }
        $this->TwoStepAuthentication = $twoStepAuthentication;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\GetUserDetailsResult
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\GetUserDetailsResult
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return \StructType\GetUserDetailsResult
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitle, true), gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\GetUserDetailsResult
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\GetUserDetailsResult
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\GetUserDetailsResult
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Emails value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getEmails()
    {
        return $this->Emails;
    }
    /**
     * Set Emails value
     * @param \ArrayType\ArrayOfString $emails
     * @return \StructType\GetUserDetailsResult
     */
    public function setEmails(\ArrayType\ArrayOfString $emails = null)
    {
        $this->Emails = $emails;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GetUserDetailsResult
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param string $timeZone
     * @return \StructType\GetUserDetailsResult
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get RoleIds value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getRoleIds()
    {
        return $this->RoleIds;
    }
    /**
     * Set RoleIds value
     * @param \ArrayType\ArrayOfString $roleIds
     * @return \StructType\GetUserDetailsResult
     */
    public function setRoleIds(\ArrayType\ArrayOfString $roleIds = null)
    {
        $this->RoleIds = $roleIds;
        return $this;
    }
    /**
     * Get TxConnectDispatcherDetails value
     * @return \StructType\TxConnectDispatcherResult|null
     */
    public function getTxConnectDispatcherDetails()
    {
        return $this->TxConnectDispatcherDetails;
    }
    /**
     * Set TxConnectDispatcherDetails value
     * @param \StructType\TxConnectDispatcherResult $txConnectDispatcherDetails
     * @return \StructType\GetUserDetailsResult
     */
    public function setTxConnectDispatcherDetails(\StructType\TxConnectDispatcherResult $txConnectDispatcherDetails = null)
    {
        $this->TxConnectDispatcherDetails = $txConnectDispatcherDetails;
        return $this;
    }
}
