<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetScannedDocuments_V4 StructType
 * @subpackage Structs
 */
class GetScannedDocuments_V4 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocumentsResult_V4
     */
    public $Documents;
    /**
     * Constructor method for GetScannedDocuments_V4
     * @uses GetScannedDocuments_V4::setMaximumModificationID()
     * @uses GetScannedDocuments_V4::setDocuments()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfDocumentsResult_V4 $documents
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfDocumentsResult_V4 $documents = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setDocuments($documents);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetScannedDocuments_V4
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get Documents value
     * @return \ArrayType\ArrayOfDocumentsResult_V4|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \ArrayType\ArrayOfDocumentsResult_V4 $documents
     * @return \StructType\GetScannedDocuments_V4
     */
    public function setDocuments(\ArrayType\ArrayOfDocumentsResult_V4 $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
}
