<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRefuelReport_V4 StructType
 * @subpackage Structs
 */
class GetRefuelReport_V4 extends ExecutionResult
{
    /**
     * The MaximumDBRegistrationTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MaximumDBRegistrationTime;
    /**
     * The MaximumDBRegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaximumDBRegistrationID;
    /**
     * The FuelReportItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFuelReportItem_V4
     */
    public $FuelReportItems;
    /**
     * Constructor method for GetRefuelReport_V4
     * @uses GetRefuelReport_V4::setMaximumDBRegistrationTime()
     * @uses GetRefuelReport_V4::setMaximumDBRegistrationID()
     * @uses GetRefuelReport_V4::setFuelReportItems()
     * @param string $maximumDBRegistrationTime
     * @param int $maximumDBRegistrationID
     * @param \ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems
     */
    public function __construct($maximumDBRegistrationTime = null, $maximumDBRegistrationID = null, \ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems = null)
    {
        $this
            ->setMaximumDBRegistrationTime($maximumDBRegistrationTime)
            ->setMaximumDBRegistrationID($maximumDBRegistrationID)
            ->setFuelReportItems($fuelReportItems);
    }
    /**
     * Get MaximumDBRegistrationTime value
     * @return string
     */
    public function getMaximumDBRegistrationTime()
    {
        return $this->MaximumDBRegistrationTime;
    }
    /**
     * Set MaximumDBRegistrationTime value
     * @param string $maximumDBRegistrationTime
     * @return \StructType\GetRefuelReport_V4
     */
    public function setMaximumDBRegistrationTime($maximumDBRegistrationTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumDBRegistrationTime) && !is_string($maximumDBRegistrationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumDBRegistrationTime, true), gettype($maximumDBRegistrationTime)), __LINE__);
        }
        $this->MaximumDBRegistrationTime = $maximumDBRegistrationTime;
        return $this;
    }
    /**
     * Get MaximumDBRegistrationID value
     * @return int
     */
    public function getMaximumDBRegistrationID()
    {
        return $this->MaximumDBRegistrationID;
    }
    /**
     * Set MaximumDBRegistrationID value
     * @param int $maximumDBRegistrationID
     * @return \StructType\GetRefuelReport_V4
     */
    public function setMaximumDBRegistrationID($maximumDBRegistrationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumDBRegistrationID) && !(is_int($maximumDBRegistrationID) || ctype_digit($maximumDBRegistrationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumDBRegistrationID, true), gettype($maximumDBRegistrationID)), __LINE__);
        }
        $this->MaximumDBRegistrationID = $maximumDBRegistrationID;
        return $this;
    }
    /**
     * Get FuelReportItems value
     * @return \ArrayType\ArrayOfFuelReportItem_V4|null
     */
    public function getFuelReportItems()
    {
        return $this->FuelReportItems;
    }
    /**
     * Set FuelReportItems value
     * @param \ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems
     * @return \StructType\GetRefuelReport_V4
     */
    public function setFuelReportItems(\ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems = null)
    {
        $this->FuelReportItems = $fuelReportItems;
        return $this;
    }
}
