<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPlanningHistoricalSelectionInterfaceResult_V5
 * StructType
 * @subpackage Structs
 */
class GetPlanningHistoricalSelectionInterfaceResult_V5 extends AbstractStructBase
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The Plannings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlanningInterfaceResult_V5
     */
    public $Plannings;
    /**
     * The Anomalies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentHistoricalResult
     */
    public $Comments;
    /**
     * Constructor method for GetPlanningHistoricalSelectionInterfaceResult_V5
     * @uses GetPlanningHistoricalSelectionInterfaceResult_V5::setMaximumModificationID()
     * @uses GetPlanningHistoricalSelectionInterfaceResult_V5::setPlannings()
     * @uses GetPlanningHistoricalSelectionInterfaceResult_V5::setAnomalies()
     * @uses GetPlanningHistoricalSelectionInterfaceResult_V5::setComments()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfPlanningInterfaceResult_V5 $plannings
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfCommentHistoricalResult $comments
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfPlanningInterfaceResult_V5 $plannings = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfCommentHistoricalResult $comments = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setPlannings($plannings)
            ->setAnomalies($anomalies)
            ->setComments($comments);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetPlanningHistoricalSelectionInterfaceResult_V5
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get Plannings value
     * @return \ArrayType\ArrayOfPlanningInterfaceResult_V5|null
     */
    public function getPlannings()
    {
        return $this->Plannings;
    }
    /**
     * Set Plannings value
     * @param \ArrayType\ArrayOfPlanningInterfaceResult_V5 $plannings
     * @return \StructType\GetPlanningHistoricalSelectionInterfaceResult_V5
     */
    public function setPlannings(\ArrayType\ArrayOfPlanningInterfaceResult_V5 $plannings = null)
    {
        $this->Plannings = $plannings;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\GetPlanningHistoricalSelectionInterfaceResult_V5
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentHistoricalResult|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentHistoricalResult $comments
     * @return \StructType\GetPlanningHistoricalSelectionInterfaceResult_V5
     */
    public function setComments(\ArrayType\ArrayOfCommentHistoricalResult $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
}
