<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEcoScoreReportItem StructType
 * @subpackage Structs
 */
class GetEcoScoreReportItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The TotalScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TotalScore;
    /**
     * The Anticipation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Anticipation;
    /**
     * The Gearing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Gearing;
    /**
     * The Idling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Idling;
    /**
     * The Technology
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Technology;
    /**
     * The Acceleration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Acceleration;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * Constructor method for GetEcoScoreReportItem
     * @uses GetEcoScoreReportItem::setDate()
     * @uses GetEcoScoreReportItem::setTotalScore()
     * @uses GetEcoScoreReportItem::setAnticipation()
     * @uses GetEcoScoreReportItem::setGearing()
     * @uses GetEcoScoreReportItem::setIdling()
     * @uses GetEcoScoreReportItem::setTechnology()
     * @uses GetEcoScoreReportItem::setAcceleration()
     * @uses GetEcoScoreReportItem::setDriver()
     * @param string $date
     * @param int $totalScore
     * @param int $anticipation
     * @param int $gearing
     * @param int $idling
     * @param int $technology
     * @param int $acceleration
     * @param \StructType\IdentifierPerson $driver
     */
    public function __construct($date = null, $totalScore = null, $anticipation = null, $gearing = null, $idling = null, $technology = null, $acceleration = null, \StructType\IdentifierPerson $driver = null)
    {
        $this
            ->setDate($date)
            ->setTotalScore($totalScore)
            ->setAnticipation($anticipation)
            ->setGearing($gearing)
            ->setIdling($idling)
            ->setTechnology($technology)
            ->setAcceleration($acceleration)
            ->setDriver($driver);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TotalScore value
     * @return int
     */
    public function getTotalScore()
    {
        return $this->TotalScore;
    }
    /**
     * Set TotalScore value
     * @param int $totalScore
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setTotalScore($totalScore = null)
    {
        // validation for constraint: int
        if (!is_null($totalScore) && !(is_int($totalScore) || ctype_digit($totalScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalScore, true), gettype($totalScore)), __LINE__);
        }
        $this->TotalScore = $totalScore;
        return $this;
    }
    /**
     * Get Anticipation value
     * @return int
     */
    public function getAnticipation()
    {
        return $this->Anticipation;
    }
    /**
     * Set Anticipation value
     * @param int $anticipation
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setAnticipation($anticipation = null)
    {
        // validation for constraint: int
        if (!is_null($anticipation) && !(is_int($anticipation) || ctype_digit($anticipation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anticipation, true), gettype($anticipation)), __LINE__);
        }
        $this->Anticipation = $anticipation;
        return $this;
    }
    /**
     * Get Gearing value
     * @return int
     */
    public function getGearing()
    {
        return $this->Gearing;
    }
    /**
     * Set Gearing value
     * @param int $gearing
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setGearing($gearing = null)
    {
        // validation for constraint: int
        if (!is_null($gearing) && !(is_int($gearing) || ctype_digit($gearing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gearing, true), gettype($gearing)), __LINE__);
        }
        $this->Gearing = $gearing;
        return $this;
    }
    /**
     * Get Idling value
     * @return int
     */
    public function getIdling()
    {
        return $this->Idling;
    }
    /**
     * Set Idling value
     * @param int $idling
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setIdling($idling = null)
    {
        // validation for constraint: int
        if (!is_null($idling) && !(is_int($idling) || ctype_digit($idling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idling, true), gettype($idling)), __LINE__);
        }
        $this->Idling = $idling;
        return $this;
    }
    /**
     * Get Technology value
     * @return int
     */
    public function getTechnology()
    {
        return $this->Technology;
    }
    /**
     * Set Technology value
     * @param int $technology
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setTechnology($technology = null)
    {
        // validation for constraint: int
        if (!is_null($technology) && !(is_int($technology) || ctype_digit($technology))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($technology, true), gettype($technology)), __LINE__);
        }
        $this->Technology = $technology;
        return $this;
    }
    /**
     * Get Acceleration value
     * @return int
     */
    public function getAcceleration()
    {
        return $this->Acceleration;
    }
    /**
     * Set Acceleration value
     * @param int $acceleration
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setAcceleration($acceleration = null)
    {
        // validation for constraint: int
        if (!is_null($acceleration) && !(is_int($acceleration) || ctype_digit($acceleration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acceleration, true), gettype($acceleration)), __LINE__);
        }
        $this->Acceleration = $acceleration;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\GetEcoScoreReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
