<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivityReportResult_V9 StructType
 * @subpackage Structs
 */
class GetActivityReportResult_V9 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The ActivityReportItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityReportItem_V9
     */
    public $ActivityReportItems;
    /**
     * Constructor method for GetActivityReportResult_V9
     * @uses GetActivityReportResult_V9::setMaximumModificationID()
     * @uses GetActivityReportResult_V9::setActivityReportItems()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfActivityReportItem_V9 $activityReportItems
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfActivityReportItem_V9 $activityReportItems = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setActivityReportItems($activityReportItems);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetActivityReportResult_V9
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get ActivityReportItems value
     * @return \ArrayType\ArrayOfActivityReportItem_V9|null
     */
    public function getActivityReportItems()
    {
        return $this->ActivityReportItems;
    }
    /**
     * Set ActivityReportItems value
     * @param \ArrayType\ArrayOfActivityReportItem_V9 $activityReportItems
     * @return \StructType\GetActivityReportResult_V9
     */
    public function setActivityReportItems(\ArrayType\ArrayOfActivityReportItem_V9 $activityReportItems = null)
    {
        $this->ActivityReportItems = $activityReportItems;
        return $this;
    }
}
