<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoZoneSelection StructType
 * @subpackage Structs
 */
class GeoZoneSelection extends AbstractStructBase
{
    /**
     * The GeoZoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoZoneID;
    /**
     * The DateStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * Constructor method for GeoZoneSelection
     * @uses GeoZoneSelection::setGeoZoneID()
     * @uses GeoZoneSelection::setDateStrategySelection()
     * @param int $geoZoneID
     * @param \StructType\DateStrategySelection $dateStrategySelection
     */
    public function __construct($geoZoneID = null, \StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this
            ->setGeoZoneID($geoZoneID)
            ->setDateStrategySelection($dateStrategySelection);
    }
    /**
     * Get GeoZoneID value
     * @return int
     */
    public function getGeoZoneID()
    {
        return $this->GeoZoneID;
    }
    /**
     * Set GeoZoneID value
     * @param int $geoZoneID
     * @return \StructType\GeoZoneSelection
     */
    public function setGeoZoneID($geoZoneID = null)
    {
        // validation for constraint: int
        if (!is_null($geoZoneID) && !(is_int($geoZoneID) || ctype_digit($geoZoneID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoZoneID, true), gettype($geoZoneID)), __LINE__);
        }
        $this->GeoZoneID = $geoZoneID;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\GeoZoneSelection
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
}
