<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericItem StructType
 * @subpackage Structs
 */
class GenericItem extends GenericBaseItem
{
    /**
     * The LiteralValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LiteralValue;
    /**
     * Constructor method for GenericItem
     * @uses GenericItem::setLiteralValue()
     * @param string $literalValue
     */
    public function __construct($literalValue = null)
    {
        $this
            ->setLiteralValue($literalValue);
    }
    /**
     * Get LiteralValue value
     * @return string|null
     */
    public function getLiteralValue()
    {
        return $this->LiteralValue;
    }
    /**
     * Set LiteralValue value
     * @param string $literalValue
     * @return \StructType\GenericItem
     */
    public function setLiteralValue($literalValue = null)
    {
        // validation for constraint: string
        if (!is_null($literalValue) && !is_string($literalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($literalValue, true), gettype($literalValue)), __LINE__);
        }
        $this->LiteralValue = $literalValue;
        return $this;
    }
}
