<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileResultItem StructType
 * @subpackage Structs
 */
class FileResultItem extends FileInfo
{
    /**
     * The TransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The FileTransferStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFileTransfer
     */
    public $FileTransferStatus;
    /**
     * Constructor method for FileResultItem
     * @uses FileResultItem::setTransicsID()
     * @uses FileResultItem::setFileTransferStatus()
     * @param int $transicsID
     * @param \ArrayType\ArrayOfFileTransfer $fileTransferStatus
     */
    public function __construct($transicsID = null, \ArrayType\ArrayOfFileTransfer $fileTransferStatus = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setFileTransferStatus($fileTransferStatus);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\FileResultItem
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !(is_int($transicsID) || ctype_digit($transicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsID, true), gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get FileTransferStatus value
     * @return \ArrayType\ArrayOfFileTransfer|null
     */
    public function getFileTransferStatus()
    {
        return $this->FileTransferStatus;
    }
    /**
     * Set FileTransferStatus value
     * @param \ArrayType\ArrayOfFileTransfer $fileTransferStatus
     * @return \StructType\FileResultItem
     */
    public function setFileTransferStatus(\ArrayType\ArrayOfFileTransfer $fileTransferStatus = null)
    {
        $this->FileTransferStatus = $fileTransferStatus;
        return $this;
    }
}
