<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeatureInfo StructType
 * @subpackage Structs
 */
class FeatureInfo extends AbstractStructBase
{
    /**
     * The Feature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature;
    /**
     * The FeatureParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeatureParameters;
    /**
     * The StreamingTechnologyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreamingTechnologyType;
    /**
     * The StreamingTechnologyDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreamingTechnologyDetails;
    /**
     * Constructor method for FeatureInfo
     * @uses FeatureInfo::setFeature()
     * @uses FeatureInfo::setFeatureParameters()
     * @uses FeatureInfo::setStreamingTechnologyType()
     * @uses FeatureInfo::setStreamingTechnologyDetails()
     * @param string $feature
     * @param string $featureParameters
     * @param string $streamingTechnologyType
     * @param string $streamingTechnologyDetails
     */
    public function __construct($feature = null, $featureParameters = null, $streamingTechnologyType = null, $streamingTechnologyDetails = null)
    {
        $this
            ->setFeature($feature)
            ->setFeatureParameters($featureParameters)
            ->setStreamingTechnologyType($streamingTechnologyType)
            ->setStreamingTechnologyDetails($streamingTechnologyDetails);
    }
    /**
     * Get Feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @param string $feature
     * @return \StructType\FeatureInfo
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: string
        if (!is_null($feature) && !is_string($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature, true), gettype($feature)), __LINE__);
        }
        $this->Feature = $feature;
        return $this;
    }
    /**
     * Get FeatureParameters value
     * @return string|null
     */
    public function getFeatureParameters()
    {
        return $this->FeatureParameters;
    }
    /**
     * Set FeatureParameters value
     * @param string $featureParameters
     * @return \StructType\FeatureInfo
     */
    public function setFeatureParameters($featureParameters = null)
    {
        // validation for constraint: string
        if (!is_null($featureParameters) && !is_string($featureParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featureParameters, true), gettype($featureParameters)), __LINE__);
        }
        $this->FeatureParameters = $featureParameters;
        return $this;
    }
    /**
     * Get StreamingTechnologyType value
     * @return string|null
     */
    public function getStreamingTechnologyType()
    {
        return $this->StreamingTechnologyType;
    }
    /**
     * Set StreamingTechnologyType value
     * @param string $streamingTechnologyType
     * @return \StructType\FeatureInfo
     */
    public function setStreamingTechnologyType($streamingTechnologyType = null)
    {
        // validation for constraint: string
        if (!is_null($streamingTechnologyType) && !is_string($streamingTechnologyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streamingTechnologyType, true), gettype($streamingTechnologyType)), __LINE__);
        }
        $this->StreamingTechnologyType = $streamingTechnologyType;
        return $this;
    }
    /**
     * Get StreamingTechnologyDetails value
     * @return string|null
     */
    public function getStreamingTechnologyDetails()
    {
        return $this->StreamingTechnologyDetails;
    }
    /**
     * Set StreamingTechnologyDetails value
     * @param string $streamingTechnologyDetails
     * @return \StructType\FeatureInfo
     */
    public function setStreamingTechnologyDetails($streamingTechnologyDetails = null)
    {
        // validation for constraint: string
        if (!is_null($streamingTechnologyDetails) && !is_string($streamingTechnologyDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streamingTechnologyDetails, true), gettype($streamingTechnologyDetails)), __LINE__);
        }
        $this->StreamingTechnologyDetails = $streamingTechnologyDetails;
        return $this;
    }
}
