<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtraInfo_V2 StructType
 * @subpackage Structs
 */
class ExtraInfo_V2 extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The InfoID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InfoID;
    /**
     * The Loaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Loaded;
    /**
     * The Unloaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Unloaded;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * The TypeCodeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCodeDescription;
    /**
     * The Export
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Export;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Trip;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Place;
    /**
     * The Job
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Job;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Product;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * Constructor method for ExtraInfo_V2
     * @uses ExtraInfo_V2::setDate()
     * @uses ExtraInfo_V2::setInfoID()
     * @uses ExtraInfo_V2::setLoaded()
     * @uses ExtraInfo_V2::setUnloaded()
     * @uses ExtraInfo_V2::setInfo()
     * @uses ExtraInfo_V2::setTypeCode()
     * @uses ExtraInfo_V2::setTypeCodeDescription()
     * @uses ExtraInfo_V2::setExport()
     * @uses ExtraInfo_V2::setActivity()
     * @uses ExtraInfo_V2::setTrip()
     * @uses ExtraInfo_V2::setPlace()
     * @uses ExtraInfo_V2::setJob()
     * @uses ExtraInfo_V2::setProduct()
     * @uses ExtraInfo_V2::setVehicle()
     * @uses ExtraInfo_V2::setDriver()
     * @uses ExtraInfo_V2::setCoDriver()
     * @param string $date
     * @param int $infoID
     * @param int $loaded
     * @param int $unloaded
     * @param string $info
     * @param string $typeCode
     * @param string $typeCodeDescription
     * @param string $export
     * @param \StructType\Activity $activity
     * @param \StructType\PlanningItem $trip
     * @param \StructType\PlanningItem $place
     * @param \StructType\PlanningItem $job
     * @param \StructType\PlanningItem $product
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     */
    public function __construct($date = null, $infoID = null, $loaded = null, $unloaded = null, $info = null, $typeCode = null, $typeCodeDescription = null, $export = null, \StructType\Activity $activity = null, \StructType\PlanningItem $trip = null, \StructType\PlanningItem $place = null, \StructType\PlanningItem $job = null, \StructType\PlanningItem $product = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this
            ->setDate($date)
            ->setInfoID($infoID)
            ->setLoaded($loaded)
            ->setUnloaded($unloaded)
            ->setInfo($info)
            ->setTypeCode($typeCode)
            ->setTypeCodeDescription($typeCodeDescription)
            ->setExport($export)
            ->setActivity($activity)
            ->setTrip($trip)
            ->setPlace($place)
            ->setJob($job)
            ->setProduct($product)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setCoDriver($coDriver);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ExtraInfo_V2
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get InfoID value
     * @return int
     */
    public function getInfoID()
    {
        return $this->InfoID;
    }
    /**
     * Set InfoID value
     * @param int $infoID
     * @return \StructType\ExtraInfo_V2
     */
    public function setInfoID($infoID = null)
    {
        // validation for constraint: int
        if (!is_null($infoID) && !(is_int($infoID) || ctype_digit($infoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infoID, true), gettype($infoID)), __LINE__);
        }
        $this->InfoID = $infoID;
        return $this;
    }
    /**
     * Get Loaded value
     * @return int
     */
    public function getLoaded()
    {
        return $this->Loaded;
    }
    /**
     * Set Loaded value
     * @param int $loaded
     * @return \StructType\ExtraInfo_V2
     */
    public function setLoaded($loaded = null)
    {
        // validation for constraint: int
        if (!is_null($loaded) && !(is_int($loaded) || ctype_digit($loaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loaded, true), gettype($loaded)), __LINE__);
        }
        $this->Loaded = $loaded;
        return $this;
    }
    /**
     * Get Unloaded value
     * @return int
     */
    public function getUnloaded()
    {
        return $this->Unloaded;
    }
    /**
     * Set Unloaded value
     * @param int $unloaded
     * @return \StructType\ExtraInfo_V2
     */
    public function setUnloaded($unloaded = null)
    {
        // validation for constraint: int
        if (!is_null($unloaded) && !(is_int($unloaded) || ctype_digit($unloaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unloaded, true), gettype($unloaded)), __LINE__);
        }
        $this->Unloaded = $unloaded;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\ExtraInfo_V2
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\ExtraInfo_V2
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get TypeCodeDescription value
     * @return string|null
     */
    public function getTypeCodeDescription()
    {
        return $this->TypeCodeDescription;
    }
    /**
     * Set TypeCodeDescription value
     * @param string $typeCodeDescription
     * @return \StructType\ExtraInfo_V2
     */
    public function setTypeCodeDescription($typeCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeCodeDescription) && !is_string($typeCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCodeDescription, true), gettype($typeCodeDescription)), __LINE__);
        }
        $this->TypeCodeDescription = $typeCodeDescription;
        return $this;
    }
    /**
     * Get Export value
     * @return string|null
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param string $export
     * @return \StructType\ExtraInfo_V2
     */
    public function setExport($export = null)
    {
        // validation for constraint: string
        if (!is_null($export) && !is_string($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\ExtraInfo_V2
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\PlanningItem|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\PlanningItem $trip
     * @return \StructType\ExtraInfo_V2
     */
    public function setTrip(\StructType\PlanningItem $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlanningItem|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlanningItem $place
     * @return \StructType\ExtraInfo_V2
     */
    public function setPlace(\StructType\PlanningItem $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\PlanningItem|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\PlanningItem $job
     * @return \StructType\ExtraInfo_V2
     */
    public function setJob(\StructType\PlanningItem $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\PlanningItem|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\PlanningItem $product
     * @return \StructType\ExtraInfo_V2
     */
    public function setProduct(\StructType\PlanningItem $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\ExtraInfo_V2
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\ExtraInfo_V2
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\ExtraInfo_V2
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
}
