<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecutionResult StructType
 * @subpackage Structs
 */
class ExecutionResult extends AbstractStructBase
{
    /**
     * The Executiontime
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Executiontime;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfError
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWarning
     */
    public $Warnings;
    /**
     * Constructor method for ExecutionResult
     * @uses ExecutionResult::setExecutiontime()
     * @uses ExecutionResult::setErrors()
     * @uses ExecutionResult::setWarnings()
     * @param float $executiontime
     * @param \ArrayType\ArrayOfError $errors
     * @param \ArrayType\ArrayOfWarning $warnings
     */
    public function __construct($executiontime = null, \ArrayType\ArrayOfError $errors = null, \ArrayType\ArrayOfWarning $warnings = null)
    {
        $this
            ->setExecutiontime($executiontime)
            ->setErrors($errors)
            ->setWarnings($warnings);
    }
    /**
     * Get Executiontime value
     * @return float
     */
    public function getExecutiontime()
    {
        return $this->Executiontime;
    }
    /**
     * Set Executiontime value
     * @param float $executiontime
     * @return \StructType\ExecutionResult
     */
    public function setExecutiontime($executiontime = null)
    {
        // validation for constraint: float
        if (!is_null($executiontime) && !(is_float($executiontime) || is_numeric($executiontime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($executiontime, true), gettype($executiontime)), __LINE__);
        }
        $this->Executiontime = $executiontime;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfError|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfError $errors
     * @return \StructType\ExecutionResult
     */
    public function setErrors(\ArrayType\ArrayOfError $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \ArrayType\ArrayOfWarning|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \ArrayType\ArrayOfWarning $warnings
     * @return \StructType\ExecutionResult
     */
    public function setWarnings(\ArrayType\ArrayOfWarning $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
}
