<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorCodeExplanation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCodeExplanation;
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCode()
     * @uses Error::setErrorCodeExplanation()
     * @uses Error::setField()
     * @uses Error::setValue()
     * @param string $errorCode
     * @param string $errorCodeExplanation
     * @param string $field
     * @param string $value
     */
    public function __construct($errorCode = null, $errorCodeExplanation = null, $field = null, $value = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorCodeExplanation($errorCodeExplanation)
            ->setField($field)
            ->setValue($value);
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\Error
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorCodeExplanation value
     * @return string|null
     */
    public function getErrorCodeExplanation()
    {
        return $this->ErrorCodeExplanation;
    }
    /**
     * Set ErrorCodeExplanation value
     * @param string $errorCodeExplanation
     * @return \StructType\Error
     */
    public function setErrorCodeExplanation($errorCodeExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($errorCodeExplanation) && !is_string($errorCodeExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCodeExplanation, true), gettype($errorCodeExplanation)), __LINE__);
        }
        $this->ErrorCodeExplanation = $errorCodeExplanation;
        return $this;
    }
    /**
     * Get Field value
     * @return string|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @param string $field
     * @return \StructType\Error
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Error
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
