<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EngineloadRPMItem StructType
 * @subpackage Structs
 */
class EngineloadRPMItem extends AbstractStructBase
{
    /**
     * The EngineLoadInPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EngineLoadInPercent;
    /**
     * The RPMAndDurationList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRPMAndDurationItem
     */
    public $RPMAndDurationList;
    /**
     * Constructor method for EngineloadRPMItem
     * @uses EngineloadRPMItem::setEngineLoadInPercent()
     * @uses EngineloadRPMItem::setRPMAndDurationList()
     * @param string $engineLoadInPercent
     * @param \ArrayType\ArrayOfRPMAndDurationItem $rPMAndDurationList
     */
    public function __construct($engineLoadInPercent = null, \ArrayType\ArrayOfRPMAndDurationItem $rPMAndDurationList = null)
    {
        $this
            ->setEngineLoadInPercent($engineLoadInPercent)
            ->setRPMAndDurationList($rPMAndDurationList);
    }
    /**
     * Get EngineLoadInPercent value
     * @return string|null
     */
    public function getEngineLoadInPercent()
    {
        return $this->EngineLoadInPercent;
    }
    /**
     * Set EngineLoadInPercent value
     * @param string $engineLoadInPercent
     * @return \StructType\EngineloadRPMItem
     */
    public function setEngineLoadInPercent($engineLoadInPercent = null)
    {
        // validation for constraint: string
        if (!is_null($engineLoadInPercent) && !is_string($engineLoadInPercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engineLoadInPercent, true), gettype($engineLoadInPercent)), __LINE__);
        }
        $this->EngineLoadInPercent = $engineLoadInPercent;
        return $this;
    }
    /**
     * Get RPMAndDurationList value
     * @return \ArrayType\ArrayOfRPMAndDurationItem|null
     */
    public function getRPMAndDurationList()
    {
        return $this->RPMAndDurationList;
    }
    /**
     * Set RPMAndDurationList value
     * @param \ArrayType\ArrayOfRPMAndDurationItem $rPMAndDurationList
     * @return \StructType\EngineloadRPMItem
     */
    public function setRPMAndDurationList(\ArrayType\ArrayOfRPMAndDurationItem $rPMAndDurationList = null)
    {
        $this->RPMAndDurationList = $rPMAndDurationList;
        return $this;
    }
}
