<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoPerformanceProfileDetails StructType
 * @subpackage Structs
 */
class EcoPerformanceProfileDetails extends AbstractStructBase
{
    /**
     * The ScoreOnTarget
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ScoreOnTarget;
    /**
     * The AverageFuelConsumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $AverageFuelConsumption;
    /**
     * The AverageSpeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $AverageSpeed;
    /**
     * The DurationIdling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $DurationIdling;
    /**
     * The HighRpm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $HighRpm;
    /**
     * The Overspeeding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $Overspeeding;
    /**
     * The DistanceCoasting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $DistanceCoasting;
    /**
     * The PanicBraking100Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $PanicBraking100Km;
    /**
     * The Retarder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $Retarder;
    /**
     * The CruiseControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $CruiseControl;
    /**
     * The StopsPer100Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $StopsPer100Km;
    /**
     * The BrakingPer100Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $BrakingPer100Km;
    /**
     * The GearingInGreenspot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $GearingInGreenspot;
    /**
     * The TopSpeedFluctuations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $TopSpeedFluctuations;
    /**
     * The RedRpm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoPerformanceProfileParameter
     */
    public $RedRpm;
    /**
     * Constructor method for EcoPerformanceProfileDetails
     * @uses EcoPerformanceProfileDetails::setScoreOnTarget()
     * @uses EcoPerformanceProfileDetails::setAverageFuelConsumption()
     * @uses EcoPerformanceProfileDetails::setAverageSpeed()
     * @uses EcoPerformanceProfileDetails::setDurationIdling()
     * @uses EcoPerformanceProfileDetails::setHighRpm()
     * @uses EcoPerformanceProfileDetails::setOverspeeding()
     * @uses EcoPerformanceProfileDetails::setDistanceCoasting()
     * @uses EcoPerformanceProfileDetails::setPanicBraking100Km()
     * @uses EcoPerformanceProfileDetails::setRetarder()
     * @uses EcoPerformanceProfileDetails::setCruiseControl()
     * @uses EcoPerformanceProfileDetails::setStopsPer100Km()
     * @uses EcoPerformanceProfileDetails::setBrakingPer100Km()
     * @uses EcoPerformanceProfileDetails::setGearingInGreenspot()
     * @uses EcoPerformanceProfileDetails::setTopSpeedFluctuations()
     * @uses EcoPerformanceProfileDetails::setRedRpm()
     * @param float $scoreOnTarget
     * @param \StructType\EcoPerformanceProfileParameter $averageFuelConsumption
     * @param \StructType\EcoPerformanceProfileParameter $averageSpeed
     * @param \StructType\EcoPerformanceProfileParameter $durationIdling
     * @param \StructType\EcoPerformanceProfileParameter $highRpm
     * @param \StructType\EcoPerformanceProfileParameter $overspeeding
     * @param \StructType\EcoPerformanceProfileParameter $distanceCoasting
     * @param \StructType\EcoPerformanceProfileParameter $panicBraking100Km
     * @param \StructType\EcoPerformanceProfileParameter $retarder
     * @param \StructType\EcoPerformanceProfileParameter $cruiseControl
     * @param \StructType\EcoPerformanceProfileParameter $stopsPer100Km
     * @param \StructType\EcoPerformanceProfileParameter $brakingPer100Km
     * @param \StructType\EcoPerformanceProfileParameter $gearingInGreenspot
     * @param \StructType\EcoPerformanceProfileParameter $topSpeedFluctuations
     * @param \StructType\EcoPerformanceProfileParameter $redRpm
     */
    public function __construct($scoreOnTarget = null, \StructType\EcoPerformanceProfileParameter $averageFuelConsumption = null, \StructType\EcoPerformanceProfileParameter $averageSpeed = null, \StructType\EcoPerformanceProfileParameter $durationIdling = null, \StructType\EcoPerformanceProfileParameter $highRpm = null, \StructType\EcoPerformanceProfileParameter $overspeeding = null, \StructType\EcoPerformanceProfileParameter $distanceCoasting = null, \StructType\EcoPerformanceProfileParameter $panicBraking100Km = null, \StructType\EcoPerformanceProfileParameter $retarder = null, \StructType\EcoPerformanceProfileParameter $cruiseControl = null, \StructType\EcoPerformanceProfileParameter $stopsPer100Km = null, \StructType\EcoPerformanceProfileParameter $brakingPer100Km = null, \StructType\EcoPerformanceProfileParameter $gearingInGreenspot = null, \StructType\EcoPerformanceProfileParameter $topSpeedFluctuations = null, \StructType\EcoPerformanceProfileParameter $redRpm = null)
    {
        $this
            ->setScoreOnTarget($scoreOnTarget)
            ->setAverageFuelConsumption($averageFuelConsumption)
            ->setAverageSpeed($averageSpeed)
            ->setDurationIdling($durationIdling)
            ->setHighRpm($highRpm)
            ->setOverspeeding($overspeeding)
            ->setDistanceCoasting($distanceCoasting)
            ->setPanicBraking100Km($panicBraking100Km)
            ->setRetarder($retarder)
            ->setCruiseControl($cruiseControl)
            ->setStopsPer100Km($stopsPer100Km)
            ->setBrakingPer100Km($brakingPer100Km)
            ->setGearingInGreenspot($gearingInGreenspot)
            ->setTopSpeedFluctuations($topSpeedFluctuations)
            ->setRedRpm($redRpm);
    }
    /**
     * Get ScoreOnTarget value
     * @return float
     */
    public function getScoreOnTarget()
    {
        return $this->ScoreOnTarget;
    }
    /**
     * Set ScoreOnTarget value
     * @param float $scoreOnTarget
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setScoreOnTarget($scoreOnTarget = null)
    {
        // validation for constraint: float
        if (!is_null($scoreOnTarget) && !(is_float($scoreOnTarget) || is_numeric($scoreOnTarget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scoreOnTarget, true), gettype($scoreOnTarget)), __LINE__);
        }
        $this->ScoreOnTarget = $scoreOnTarget;
        return $this;
    }
    /**
     * Get AverageFuelConsumption value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getAverageFuelConsumption()
    {
        return $this->AverageFuelConsumption;
    }
    /**
     * Set AverageFuelConsumption value
     * @param \StructType\EcoPerformanceProfileParameter $averageFuelConsumption
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setAverageFuelConsumption(\StructType\EcoPerformanceProfileParameter $averageFuelConsumption = null)
    {
        $this->AverageFuelConsumption = $averageFuelConsumption;
        return $this;
    }
    /**
     * Get AverageSpeed value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getAverageSpeed()
    {
        return $this->AverageSpeed;
    }
    /**
     * Set AverageSpeed value
     * @param \StructType\EcoPerformanceProfileParameter $averageSpeed
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setAverageSpeed(\StructType\EcoPerformanceProfileParameter $averageSpeed = null)
    {
        $this->AverageSpeed = $averageSpeed;
        return $this;
    }
    /**
     * Get DurationIdling value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getDurationIdling()
    {
        return $this->DurationIdling;
    }
    /**
     * Set DurationIdling value
     * @param \StructType\EcoPerformanceProfileParameter $durationIdling
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setDurationIdling(\StructType\EcoPerformanceProfileParameter $durationIdling = null)
    {
        $this->DurationIdling = $durationIdling;
        return $this;
    }
    /**
     * Get HighRpm value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getHighRpm()
    {
        return $this->HighRpm;
    }
    /**
     * Set HighRpm value
     * @param \StructType\EcoPerformanceProfileParameter $highRpm
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setHighRpm(\StructType\EcoPerformanceProfileParameter $highRpm = null)
    {
        $this->HighRpm = $highRpm;
        return $this;
    }
    /**
     * Get Overspeeding value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getOverspeeding()
    {
        return $this->Overspeeding;
    }
    /**
     * Set Overspeeding value
     * @param \StructType\EcoPerformanceProfileParameter $overspeeding
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setOverspeeding(\StructType\EcoPerformanceProfileParameter $overspeeding = null)
    {
        $this->Overspeeding = $overspeeding;
        return $this;
    }
    /**
     * Get DistanceCoasting value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getDistanceCoasting()
    {
        return $this->DistanceCoasting;
    }
    /**
     * Set DistanceCoasting value
     * @param \StructType\EcoPerformanceProfileParameter $distanceCoasting
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setDistanceCoasting(\StructType\EcoPerformanceProfileParameter $distanceCoasting = null)
    {
        $this->DistanceCoasting = $distanceCoasting;
        return $this;
    }
    /**
     * Get PanicBraking100Km value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getPanicBraking100Km()
    {
        return $this->PanicBraking100Km;
    }
    /**
     * Set PanicBraking100Km value
     * @param \StructType\EcoPerformanceProfileParameter $panicBraking100Km
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setPanicBraking100Km(\StructType\EcoPerformanceProfileParameter $panicBraking100Km = null)
    {
        $this->PanicBraking100Km = $panicBraking100Km;
        return $this;
    }
    /**
     * Get Retarder value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getRetarder()
    {
        return $this->Retarder;
    }
    /**
     * Set Retarder value
     * @param \StructType\EcoPerformanceProfileParameter $retarder
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setRetarder(\StructType\EcoPerformanceProfileParameter $retarder = null)
    {
        $this->Retarder = $retarder;
        return $this;
    }
    /**
     * Get CruiseControl value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getCruiseControl()
    {
        return $this->CruiseControl;
    }
    /**
     * Set CruiseControl value
     * @param \StructType\EcoPerformanceProfileParameter $cruiseControl
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setCruiseControl(\StructType\EcoPerformanceProfileParameter $cruiseControl = null)
    {
        $this->CruiseControl = $cruiseControl;
        return $this;
    }
    /**
     * Get StopsPer100Km value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getStopsPer100Km()
    {
        return $this->StopsPer100Km;
    }
    /**
     * Set StopsPer100Km value
     * @param \StructType\EcoPerformanceProfileParameter $stopsPer100Km
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setStopsPer100Km(\StructType\EcoPerformanceProfileParameter $stopsPer100Km = null)
    {
        $this->StopsPer100Km = $stopsPer100Km;
        return $this;
    }
    /**
     * Get BrakingPer100Km value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getBrakingPer100Km()
    {
        return $this->BrakingPer100Km;
    }
    /**
     * Set BrakingPer100Km value
     * @param \StructType\EcoPerformanceProfileParameter $brakingPer100Km
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setBrakingPer100Km(\StructType\EcoPerformanceProfileParameter $brakingPer100Km = null)
    {
        $this->BrakingPer100Km = $brakingPer100Km;
        return $this;
    }
    /**
     * Get GearingInGreenspot value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getGearingInGreenspot()
    {
        return $this->GearingInGreenspot;
    }
    /**
     * Set GearingInGreenspot value
     * @param \StructType\EcoPerformanceProfileParameter $gearingInGreenspot
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setGearingInGreenspot(\StructType\EcoPerformanceProfileParameter $gearingInGreenspot = null)
    {
        $this->GearingInGreenspot = $gearingInGreenspot;
        return $this;
    }
    /**
     * Get TopSpeedFluctuations value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getTopSpeedFluctuations()
    {
        return $this->TopSpeedFluctuations;
    }
    /**
     * Set TopSpeedFluctuations value
     * @param \StructType\EcoPerformanceProfileParameter $topSpeedFluctuations
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setTopSpeedFluctuations(\StructType\EcoPerformanceProfileParameter $topSpeedFluctuations = null)
    {
        $this->TopSpeedFluctuations = $topSpeedFluctuations;
        return $this;
    }
    /**
     * Get RedRpm value
     * @return \StructType\EcoPerformanceProfileParameter|null
     */
    public function getRedRpm()
    {
        return $this->RedRpm;
    }
    /**
     * Set RedRpm value
     * @param \StructType\EcoPerformanceProfileParameter $redRpm
     * @return \StructType\EcoPerformanceProfileDetails
     */
    public function setRedRpm(\StructType\EcoPerformanceProfileParameter $redRpm = null)
    {
        $this->RedRpm = $redRpm;
        return $this;
    }
}
