<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorPtoResult StructType
 * @subpackage Structs
 */
class EcoMonitorPtoResult extends AbstractStructBase
{
    /**
     * The NumberOfPto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfPto;
    /**
     * The FuelConsumptionPtoDriving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionPtoDriving;
    /**
     * The FuelConsumptionPtoStandStill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionPtoStandStill;
    /**
     * The DurationPtoDriving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationPtoDriving;
    /**
     * The DurationPtoStandStill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationPtoStandStill;
    /**
     * Constructor method for EcoMonitorPtoResult
     * @uses EcoMonitorPtoResult::setNumberOfPto()
     * @uses EcoMonitorPtoResult::setFuelConsumptionPtoDriving()
     * @uses EcoMonitorPtoResult::setFuelConsumptionPtoStandStill()
     * @uses EcoMonitorPtoResult::setDurationPtoDriving()
     * @uses EcoMonitorPtoResult::setDurationPtoStandStill()
     * @param int $numberOfPto
     * @param float $fuelConsumptionPtoDriving
     * @param float $fuelConsumptionPtoStandStill
     * @param float $durationPtoDriving
     * @param float $durationPtoStandStill
     */
    public function __construct($numberOfPto = null, $fuelConsumptionPtoDriving = null, $fuelConsumptionPtoStandStill = null, $durationPtoDriving = null, $durationPtoStandStill = null)
    {
        $this
            ->setNumberOfPto($numberOfPto)
            ->setFuelConsumptionPtoDriving($fuelConsumptionPtoDriving)
            ->setFuelConsumptionPtoStandStill($fuelConsumptionPtoStandStill)
            ->setDurationPtoDriving($durationPtoDriving)
            ->setDurationPtoStandStill($durationPtoStandStill);
    }
    /**
     * Get NumberOfPto value
     * @return int
     */
    public function getNumberOfPto()
    {
        return $this->NumberOfPto;
    }
    /**
     * Set NumberOfPto value
     * @param int $numberOfPto
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setNumberOfPto($numberOfPto = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPto) && !(is_int($numberOfPto) || ctype_digit($numberOfPto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPto, true), gettype($numberOfPto)), __LINE__);
        }
        $this->NumberOfPto = $numberOfPto;
        return $this;
    }
    /**
     * Get FuelConsumptionPtoDriving value
     * @return float
     */
    public function getFuelConsumptionPtoDriving()
    {
        return $this->FuelConsumptionPtoDriving;
    }
    /**
     * Set FuelConsumptionPtoDriving value
     * @param float $fuelConsumptionPtoDriving
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setFuelConsumptionPtoDriving($fuelConsumptionPtoDriving = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionPtoDriving) && !(is_float($fuelConsumptionPtoDriving) || is_numeric($fuelConsumptionPtoDriving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionPtoDriving, true), gettype($fuelConsumptionPtoDriving)), __LINE__);
        }
        $this->FuelConsumptionPtoDriving = $fuelConsumptionPtoDriving;
        return $this;
    }
    /**
     * Get FuelConsumptionPtoStandStill value
     * @return float
     */
    public function getFuelConsumptionPtoStandStill()
    {
        return $this->FuelConsumptionPtoStandStill;
    }
    /**
     * Set FuelConsumptionPtoStandStill value
     * @param float $fuelConsumptionPtoStandStill
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setFuelConsumptionPtoStandStill($fuelConsumptionPtoStandStill = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionPtoStandStill) && !(is_float($fuelConsumptionPtoStandStill) || is_numeric($fuelConsumptionPtoStandStill))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionPtoStandStill, true), gettype($fuelConsumptionPtoStandStill)), __LINE__);
        }
        $this->FuelConsumptionPtoStandStill = $fuelConsumptionPtoStandStill;
        return $this;
    }
    /**
     * Get DurationPtoDriving value
     * @return float
     */
    public function getDurationPtoDriving()
    {
        return $this->DurationPtoDriving;
    }
    /**
     * Set DurationPtoDriving value
     * @param float $durationPtoDriving
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setDurationPtoDriving($durationPtoDriving = null)
    {
        // validation for constraint: float
        if (!is_null($durationPtoDriving) && !(is_float($durationPtoDriving) || is_numeric($durationPtoDriving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationPtoDriving, true), gettype($durationPtoDriving)), __LINE__);
        }
        $this->DurationPtoDriving = $durationPtoDriving;
        return $this;
    }
    /**
     * Get DurationPtoStandStill value
     * @return float
     */
    public function getDurationPtoStandStill()
    {
        return $this->DurationPtoStandStill;
    }
    /**
     * Set DurationPtoStandStill value
     * @param float $durationPtoStandStill
     * @return \StructType\EcoMonitorPtoResult
     */
    public function setDurationPtoStandStill($durationPtoStandStill = null)
    {
        // validation for constraint: float
        if (!is_null($durationPtoStandStill) && !(is_float($durationPtoStandStill) || is_numeric($durationPtoStandStill))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationPtoStandStill, true), gettype($durationPtoStandStill)), __LINE__);
        }
        $this->DurationPtoStandStill = $durationPtoStandStill;
        return $this;
    }
}
