<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorDataResult StructType
 * @subpackage Structs
 */
class EcoMonitorDataResult extends AbstractStructBase
{
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Distance;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration;
    /**
     * The DurationDriving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationDriving;
    /**
     * The FuelConsumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumption;
    /**
     * The FuelConsumptionAverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionAverage;
    /**
     * The RpmAverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RpmAverage;
    /**
     * The Co2EmissionAverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Co2EmissionAverage;
    /**
     * The SpeedAverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpeedAverage;
    /**
     * Constructor method for EcoMonitorDataResult
     * @uses EcoMonitorDataResult::setDistance()
     * @uses EcoMonitorDataResult::setDuration()
     * @uses EcoMonitorDataResult::setDurationDriving()
     * @uses EcoMonitorDataResult::setFuelConsumption()
     * @uses EcoMonitorDataResult::setFuelConsumptionAverage()
     * @uses EcoMonitorDataResult::setRpmAverage()
     * @uses EcoMonitorDataResult::setCo2EmissionAverage()
     * @uses EcoMonitorDataResult::setSpeedAverage()
     * @param float $distance
     * @param float $duration
     * @param float $durationDriving
     * @param float $fuelConsumption
     * @param float $fuelConsumptionAverage
     * @param float $rpmAverage
     * @param float $co2EmissionAverage
     * @param float $speedAverage
     */
    public function __construct($distance = null, $duration = null, $durationDriving = null, $fuelConsumption = null, $fuelConsumptionAverage = null, $rpmAverage = null, $co2EmissionAverage = null, $speedAverage = null)
    {
        $this
            ->setDistance($distance)
            ->setDuration($duration)
            ->setDurationDriving($durationDriving)
            ->setFuelConsumption($fuelConsumption)
            ->setFuelConsumptionAverage($fuelConsumptionAverage)
            ->setRpmAverage($rpmAverage)
            ->setCo2EmissionAverage($co2EmissionAverage)
            ->setSpeedAverage($speedAverage);
    }
    /**
     * Get Distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\EcoMonitorDataResult
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: float
        if (!is_null($distance) && !(is_float($distance) || is_numeric($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Duration value
     * @return float
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param float $duration
     * @return \StructType\EcoMonitorDataResult
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: float
        if (!is_null($duration) && !(is_float($duration) || is_numeric($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get DurationDriving value
     * @return float
     */
    public function getDurationDriving()
    {
        return $this->DurationDriving;
    }
    /**
     * Set DurationDriving value
     * @param float $durationDriving
     * @return \StructType\EcoMonitorDataResult
     */
    public function setDurationDriving($durationDriving = null)
    {
        // validation for constraint: float
        if (!is_null($durationDriving) && !(is_float($durationDriving) || is_numeric($durationDriving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationDriving, true), gettype($durationDriving)), __LINE__);
        }
        $this->DurationDriving = $durationDriving;
        return $this;
    }
    /**
     * Get FuelConsumption value
     * @return float
     */
    public function getFuelConsumption()
    {
        return $this->FuelConsumption;
    }
    /**
     * Set FuelConsumption value
     * @param float $fuelConsumption
     * @return \StructType\EcoMonitorDataResult
     */
    public function setFuelConsumption($fuelConsumption = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumption) && !(is_float($fuelConsumption) || is_numeric($fuelConsumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumption, true), gettype($fuelConsumption)), __LINE__);
        }
        $this->FuelConsumption = $fuelConsumption;
        return $this;
    }
    /**
     * Get FuelConsumptionAverage value
     * @return float
     */
    public function getFuelConsumptionAverage()
    {
        return $this->FuelConsumptionAverage;
    }
    /**
     * Set FuelConsumptionAverage value
     * @param float $fuelConsumptionAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setFuelConsumptionAverage($fuelConsumptionAverage = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionAverage) && !(is_float($fuelConsumptionAverage) || is_numeric($fuelConsumptionAverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionAverage, true), gettype($fuelConsumptionAverage)), __LINE__);
        }
        $this->FuelConsumptionAverage = $fuelConsumptionAverage;
        return $this;
    }
    /**
     * Get RpmAverage value
     * @return float
     */
    public function getRpmAverage()
    {
        return $this->RpmAverage;
    }
    /**
     * Set RpmAverage value
     * @param float $rpmAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setRpmAverage($rpmAverage = null)
    {
        // validation for constraint: float
        if (!is_null($rpmAverage) && !(is_float($rpmAverage) || is_numeric($rpmAverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rpmAverage, true), gettype($rpmAverage)), __LINE__);
        }
        $this->RpmAverage = $rpmAverage;
        return $this;
    }
    /**
     * Get Co2EmissionAverage value
     * @return float
     */
    public function getCo2EmissionAverage()
    {
        return $this->Co2EmissionAverage;
    }
    /**
     * Set Co2EmissionAverage value
     * @param float $co2EmissionAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setCo2EmissionAverage($co2EmissionAverage = null)
    {
        // validation for constraint: float
        if (!is_null($co2EmissionAverage) && !(is_float($co2EmissionAverage) || is_numeric($co2EmissionAverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($co2EmissionAverage, true), gettype($co2EmissionAverage)), __LINE__);
        }
        $this->Co2EmissionAverage = $co2EmissionAverage;
        return $this;
    }
    /**
     * Get SpeedAverage value
     * @return float
     */
    public function getSpeedAverage()
    {
        return $this->SpeedAverage;
    }
    /**
     * Set SpeedAverage value
     * @param float $speedAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setSpeedAverage($speedAverage = null)
    {
        // validation for constraint: float
        if (!is_null($speedAverage) && !(is_float($speedAverage) || is_numeric($speedAverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speedAverage, true), gettype($speedAverage)), __LINE__);
        }
        $this->SpeedAverage = $speedAverage;
        return $this;
    }
}
