<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorCruisingResult_V2 StructType
 * @subpackage Structs
 */
class EcoMonitorCruisingResult_V2 extends EcoMonitorCruisingResult
{
    /**
     * The DistanceOnCruiseControlPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceOnCruiseControlPercentage;
    /**
     * The AvgFuelConsumptionCruiseControlInLiterPer100km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AvgFuelConsumptionCruiseControlInLiterPer100km;
    /**
     * The AvgFuelConsumptionCruiseControlInkmPerLiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AvgFuelConsumptionCruiseControlInkmPerLiter;
    /**
     * Constructor method for EcoMonitorCruisingResult_V2
     * @uses EcoMonitorCruisingResult_V2::setDistanceOnCruiseControlPercentage()
     * @uses EcoMonitorCruisingResult_V2::setAvgFuelConsumptionCruiseControlInLiterPer100km()
     * @uses EcoMonitorCruisingResult_V2::setAvgFuelConsumptionCruiseControlInkmPerLiter()
     * @param float $distanceOnCruiseControlPercentage
     * @param float $avgFuelConsumptionCruiseControlInLiterPer100km
     * @param float $avgFuelConsumptionCruiseControlInkmPerLiter
     */
    public function __construct($distanceOnCruiseControlPercentage = null, $avgFuelConsumptionCruiseControlInLiterPer100km = null, $avgFuelConsumptionCruiseControlInkmPerLiter = null)
    {
        $this
            ->setDistanceOnCruiseControlPercentage($distanceOnCruiseControlPercentage)
            ->setAvgFuelConsumptionCruiseControlInLiterPer100km($avgFuelConsumptionCruiseControlInLiterPer100km)
            ->setAvgFuelConsumptionCruiseControlInkmPerLiter($avgFuelConsumptionCruiseControlInkmPerLiter);
    }
    /**
     * Get DistanceOnCruiseControlPercentage value
     * @return float
     */
    public function getDistanceOnCruiseControlPercentage()
    {
        return $this->DistanceOnCruiseControlPercentage;
    }
    /**
     * Set DistanceOnCruiseControlPercentage value
     * @param float $distanceOnCruiseControlPercentage
     * @return \StructType\EcoMonitorCruisingResult_V2
     */
    public function setDistanceOnCruiseControlPercentage($distanceOnCruiseControlPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($distanceOnCruiseControlPercentage) && !(is_float($distanceOnCruiseControlPercentage) || is_numeric($distanceOnCruiseControlPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceOnCruiseControlPercentage, true), gettype($distanceOnCruiseControlPercentage)), __LINE__);
        }
        $this->DistanceOnCruiseControlPercentage = $distanceOnCruiseControlPercentage;
        return $this;
    }
    /**
     * Get AvgFuelConsumptionCruiseControlInLiterPer100km value
     * @return float
     */
    public function getAvgFuelConsumptionCruiseControlInLiterPer100km()
    {
        return $this->AvgFuelConsumptionCruiseControlInLiterPer100km;
    }
    /**
     * Set AvgFuelConsumptionCruiseControlInLiterPer100km value
     * @param float $avgFuelConsumptionCruiseControlInLiterPer100km
     * @return \StructType\EcoMonitorCruisingResult_V2
     */
    public function setAvgFuelConsumptionCruiseControlInLiterPer100km($avgFuelConsumptionCruiseControlInLiterPer100km = null)
    {
        // validation for constraint: float
        if (!is_null($avgFuelConsumptionCruiseControlInLiterPer100km) && !(is_float($avgFuelConsumptionCruiseControlInLiterPer100km) || is_numeric($avgFuelConsumptionCruiseControlInLiterPer100km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avgFuelConsumptionCruiseControlInLiterPer100km, true), gettype($avgFuelConsumptionCruiseControlInLiterPer100km)), __LINE__);
        }
        $this->AvgFuelConsumptionCruiseControlInLiterPer100km = $avgFuelConsumptionCruiseControlInLiterPer100km;
        return $this;
    }
    /**
     * Get AvgFuelConsumptionCruiseControlInkmPerLiter value
     * @return float
     */
    public function getAvgFuelConsumptionCruiseControlInkmPerLiter()
    {
        return $this->AvgFuelConsumptionCruiseControlInkmPerLiter;
    }
    /**
     * Set AvgFuelConsumptionCruiseControlInkmPerLiter value
     * @param float $avgFuelConsumptionCruiseControlInkmPerLiter
     * @return \StructType\EcoMonitorCruisingResult_V2
     */
    public function setAvgFuelConsumptionCruiseControlInkmPerLiter($avgFuelConsumptionCruiseControlInkmPerLiter = null)
    {
        // validation for constraint: float
        if (!is_null($avgFuelConsumptionCruiseControlInkmPerLiter) && !(is_float($avgFuelConsumptionCruiseControlInkmPerLiter) || is_numeric($avgFuelConsumptionCruiseControlInkmPerLiter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avgFuelConsumptionCruiseControlInkmPerLiter, true), gettype($avgFuelConsumptionCruiseControlInkmPerLiter)), __LINE__);
        }
        $this->AvgFuelConsumptionCruiseControlInkmPerLiter = $avgFuelConsumptionCruiseControlInkmPerLiter;
        return $this;
    }
}
