<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorCruisingResult StructType
 * @subpackage Structs
 */
class EcoMonitorCruisingResult extends AbstractStructBase
{
    /**
     * The DistanceOnCruiseControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceOnCruiseControl;
    /**
     * The DurationOnCruiseControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationOnCruiseControl;
    /**
     * Constructor method for EcoMonitorCruisingResult
     * @uses EcoMonitorCruisingResult::setDistanceOnCruiseControl()
     * @uses EcoMonitorCruisingResult::setDurationOnCruiseControl()
     * @param float $distanceOnCruiseControl
     * @param float $durationOnCruiseControl
     */
    public function __construct($distanceOnCruiseControl = null, $durationOnCruiseControl = null)
    {
        $this
            ->setDistanceOnCruiseControl($distanceOnCruiseControl)
            ->setDurationOnCruiseControl($durationOnCruiseControl);
    }
    /**
     * Get DistanceOnCruiseControl value
     * @return float
     */
    public function getDistanceOnCruiseControl()
    {
        return $this->DistanceOnCruiseControl;
    }
    /**
     * Set DistanceOnCruiseControl value
     * @param float $distanceOnCruiseControl
     * @return \StructType\EcoMonitorCruisingResult
     */
    public function setDistanceOnCruiseControl($distanceOnCruiseControl = null)
    {
        // validation for constraint: float
        if (!is_null($distanceOnCruiseControl) && !(is_float($distanceOnCruiseControl) || is_numeric($distanceOnCruiseControl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceOnCruiseControl, true), gettype($distanceOnCruiseControl)), __LINE__);
        }
        $this->DistanceOnCruiseControl = $distanceOnCruiseControl;
        return $this;
    }
    /**
     * Get DurationOnCruiseControl value
     * @return float
     */
    public function getDurationOnCruiseControl()
    {
        return $this->DurationOnCruiseControl;
    }
    /**
     * Set DurationOnCruiseControl value
     * @param float $durationOnCruiseControl
     * @return \StructType\EcoMonitorCruisingResult
     */
    public function setDurationOnCruiseControl($durationOnCruiseControl = null)
    {
        // validation for constraint: float
        if (!is_null($durationOnCruiseControl) && !(is_float($durationOnCruiseControl) || is_numeric($durationOnCruiseControl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationOnCruiseControl, true), gettype($durationOnCruiseControl)), __LINE__);
        }
        $this->DurationOnCruiseControl = $durationOnCruiseControl;
        return $this;
    }
}
