<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorCoastingResult StructType
 * @subpackage Structs
 */
class EcoMonitorCoastingResult extends AbstractStructBase
{
    /**
     * The DistanceCoasting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceCoasting;
    /**
     * The DurationCoasting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationCoasting;
    /**
     * Constructor method for EcoMonitorCoastingResult
     * @uses EcoMonitorCoastingResult::setDistanceCoasting()
     * @uses EcoMonitorCoastingResult::setDurationCoasting()
     * @param float $distanceCoasting
     * @param float $durationCoasting
     */
    public function __construct($distanceCoasting = null, $durationCoasting = null)
    {
        $this
            ->setDistanceCoasting($distanceCoasting)
            ->setDurationCoasting($durationCoasting);
    }
    /**
     * Get DistanceCoasting value
     * @return float
     */
    public function getDistanceCoasting()
    {
        return $this->DistanceCoasting;
    }
    /**
     * Set DistanceCoasting value
     * @param float $distanceCoasting
     * @return \StructType\EcoMonitorCoastingResult
     */
    public function setDistanceCoasting($distanceCoasting = null)
    {
        // validation for constraint: float
        if (!is_null($distanceCoasting) && !(is_float($distanceCoasting) || is_numeric($distanceCoasting))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceCoasting, true), gettype($distanceCoasting)), __LINE__);
        }
        $this->DistanceCoasting = $distanceCoasting;
        return $this;
    }
    /**
     * Get DurationCoasting value
     * @return float
     */
    public function getDurationCoasting()
    {
        return $this->DurationCoasting;
    }
    /**
     * Set DurationCoasting value
     * @param float $durationCoasting
     * @return \StructType\EcoMonitorCoastingResult
     */
    public function setDurationCoasting($durationCoasting = null)
    {
        // validation for constraint: float
        if (!is_null($durationCoasting) && !(is_float($durationCoasting) || is_numeric($durationCoasting))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationCoasting, true), gettype($durationCoasting)), __LINE__);
        }
        $this->DurationCoasting = $durationCoasting;
        return $this;
    }
}
