<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoAssistantWeekItem StructType
 * @subpackage Structs
 */
class EcoAssistantWeekItem extends EcoAssistantItem
{
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The EcoAssistantDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEcoAssistantDayItem
     */
    public $EcoAssistantDays;
    /**
     * Constructor method for EcoAssistantWeekItem
     * @uses EcoAssistantWeekItem::setDistance()
     * @uses EcoAssistantWeekItem::setEcoAssistantDays()
     * @param int $distance
     * @param \ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays
     */
    public function __construct($distance = null, \ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays = null)
    {
        $this
            ->setDistance($distance)
            ->setEcoAssistantDays($ecoAssistantDays);
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\EcoAssistantWeekItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get EcoAssistantDays value
     * @return \ArrayType\ArrayOfEcoAssistantDayItem|null
     */
    public function getEcoAssistantDays()
    {
        return $this->EcoAssistantDays;
    }
    /**
     * Set EcoAssistantDays value
     * @param \ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays
     * @return \StructType\EcoAssistantWeekItem
     */
    public function setEcoAssistantDays(\ArrayType\ArrayOfEcoAssistantDayItem $ecoAssistantDays = null)
    {
        $this->EcoAssistantDays = $ecoAssistantDays;
        return $this;
    }
}
