<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverSocialProfileItem StructType
 * @subpackage Structs
 */
class DriverSocialProfileItem extends AbstractStructBase
{
    /**
     * The PersonTransicsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsId;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Inactive;
    /**
     * The PersonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonId;
    /**
     * The PersonExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonExternalCode;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The ProfileList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSocialProfileItem
     */
    public $ProfileList;
    /**
     * Constructor method for DriverSocialProfileItem
     * @uses DriverSocialProfileItem::setPersonTransicsId()
     * @uses DriverSocialProfileItem::setInactive()
     * @uses DriverSocialProfileItem::setPersonId()
     * @uses DriverSocialProfileItem::setPersonExternalCode()
     * @uses DriverSocialProfileItem::setLastName()
     * @uses DriverSocialProfileItem::setFirstname()
     * @uses DriverSocialProfileItem::setProfileList()
     * @param int $personTransicsId
     * @param bool $inactive
     * @param string $personId
     * @param string $personExternalCode
     * @param string $lastName
     * @param string $firstname
     * @param \ArrayType\ArrayOfSocialProfileItem $profileList
     */
    public function __construct($personTransicsId = null, $inactive = null, $personId = null, $personExternalCode = null, $lastName = null, $firstname = null, \ArrayType\ArrayOfSocialProfileItem $profileList = null)
    {
        $this
            ->setPersonTransicsId($personTransicsId)
            ->setInactive($inactive)
            ->setPersonId($personId)
            ->setPersonExternalCode($personExternalCode)
            ->setLastName($lastName)
            ->setFirstname($firstname)
            ->setProfileList($profileList);
    }
    /**
     * Get PersonTransicsId value
     * @return int
     */
    public function getPersonTransicsId()
    {
        return $this->PersonTransicsId;
    }
    /**
     * Set PersonTransicsId value
     * @param int $personTransicsId
     * @return \StructType\DriverSocialProfileItem
     */
    public function setPersonTransicsId($personTransicsId = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsId) && !(is_int($personTransicsId) || ctype_digit($personTransicsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personTransicsId, true), gettype($personTransicsId)), __LINE__);
        }
        $this->PersonTransicsId = $personTransicsId;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\DriverSocialProfileItem
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get PersonId value
     * @return string|null
     */
    public function getPersonId()
    {
        return $this->PersonId;
    }
    /**
     * Set PersonId value
     * @param string $personId
     * @return \StructType\DriverSocialProfileItem
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personId, true), gettype($personId)), __LINE__);
        }
        $this->PersonId = $personId;
        return $this;
    }
    /**
     * Get PersonExternalCode value
     * @return string|null
     */
    public function getPersonExternalCode()
    {
        return $this->PersonExternalCode;
    }
    /**
     * Set PersonExternalCode value
     * @param string $personExternalCode
     * @return \StructType\DriverSocialProfileItem
     */
    public function setPersonExternalCode($personExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($personExternalCode) && !is_string($personExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personExternalCode, true), gettype($personExternalCode)), __LINE__);
        }
        $this->PersonExternalCode = $personExternalCode;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\DriverSocialProfileItem
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\DriverSocialProfileItem
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get ProfileList value
     * @return \ArrayType\ArrayOfSocialProfileItem|null
     */
    public function getProfileList()
    {
        return $this->ProfileList;
    }
    /**
     * Set ProfileList value
     * @param \ArrayType\ArrayOfSocialProfileItem $profileList
     * @return \StructType\DriverSocialProfileItem
     */
    public function setProfileList(\ArrayType\ArrayOfSocialProfileItem $profileList = null)
    {
        $this->ProfileList = $profileList;
        return $this;
    }
}
