<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document_V5 StructType
 * @subpackage Structs
 */
class Document_V5 extends Document_V4
{
    /**
     * The Job
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JobIdentifier
     */
    public $Job;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductIdentifier
     */
    public $Product;
    /**
     * Constructor method for Document_V5
     * @uses Document_V5::setJob()
     * @uses Document_V5::setProduct()
     * @param \StructType\JobIdentifier $job
     * @param \StructType\ProductIdentifier $product
     */
    public function __construct(\StructType\JobIdentifier $job = null, \StructType\ProductIdentifier $product = null)
    {
        $this
            ->setJob($job)
            ->setProduct($product);
    }
    /**
     * Get Job value
     * @return \StructType\JobIdentifier|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\JobIdentifier $job
     * @return \StructType\Document_V5
     */
    public function setJob(\StructType\JobIdentifier $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\ProductIdentifier|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\ProductIdentifier $product
     * @return \StructType\Document_V5
     */
    public function setProduct(\StructType\ProductIdentifier $product = null)
    {
        $this->Product = $product;
        return $this;
    }
}
