<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentResult_V2 StructType
 * @subpackage Structs
 */
class DocumentResult_V2 extends Document_V2
{
    /**
     * The PageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNumber;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document;
    /**
     * Constructor method for DocumentResult_V2
     * @uses DocumentResult_V2::setPageNumber()
     * @uses DocumentResult_V2::setDocument()
     * @param int $pageNumber
     * @param string $document
     */
    public function __construct($pageNumber = null, $document = null)
    {
        $this
            ->setPageNumber($pageNumber)
            ->setDocument($document);
    }
    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\DocumentResult_V2
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get Document value
     * @return string|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param string $document
     * @return \StructType\DocumentResult_V2
     */
    public function setDocument($document = null)
    {
        // validation for constraint: string
        if (!is_null($document) && !is_string($document)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document, true), gettype($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
}
