<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayCode_V2 StructType
 * @subpackage Structs
 */
class DayCode_V2 extends AbstractStructBase
{
    /**
     * The AbsenceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AbsenceDate;
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The Amplitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amplitude;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The TypeOfDayCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfDayCode;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The PayReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReference;
    /**
     * The From1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From1;
    /**
     * The Until1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Until1;
    /**
     * The From2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From2;
    /**
     * The Until2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Until2;
    /**
     * The SocialCabinetDayCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SocialCabinetDayCode;
    /**
     * Constructor method for DayCode_V2
     * @uses DayCode_V2::setAbsenceDate()
     * @uses DayCode_V2::setSynchronizationDate()
     * @uses DayCode_V2::setAmplitude()
     * @uses DayCode_V2::setCode()
     * @uses DayCode_V2::setDescription()
     * @uses DayCode_V2::setTypeOfDayCode()
     * @uses DayCode_V2::setExternalReference()
     * @uses DayCode_V2::setPayReference()
     * @uses DayCode_V2::setFrom1()
     * @uses DayCode_V2::setUntil1()
     * @uses DayCode_V2::setFrom2()
     * @uses DayCode_V2::setUntil2()
     * @uses DayCode_V2::setSocialCabinetDayCode()
     * @param string $absenceDate
     * @param string $synchronizationDate
     * @param float $amplitude
     * @param string $code
     * @param string $description
     * @param string $typeOfDayCode
     * @param string $externalReference
     * @param string $payReference
     * @param string $from1
     * @param string $until1
     * @param string $from2
     * @param string $until2
     * @param string $socialCabinetDayCode
     */
    public function __construct($absenceDate = null, $synchronizationDate = null, $amplitude = null, $code = null, $description = null, $typeOfDayCode = null, $externalReference = null, $payReference = null, $from1 = null, $until1 = null, $from2 = null, $until2 = null, $socialCabinetDayCode = null)
    {
        $this
            ->setAbsenceDate($absenceDate)
            ->setSynchronizationDate($synchronizationDate)
            ->setAmplitude($amplitude)
            ->setCode($code)
            ->setDescription($description)
            ->setTypeOfDayCode($typeOfDayCode)
            ->setExternalReference($externalReference)
            ->setPayReference($payReference)
            ->setFrom1($from1)
            ->setUntil1($until1)
            ->setFrom2($from2)
            ->setUntil2($until2)
            ->setSocialCabinetDayCode($socialCabinetDayCode);
    }
    /**
     * Get AbsenceDate value
     * @return string
     */
    public function getAbsenceDate()
    {
        return $this->AbsenceDate;
    }
    /**
     * Set AbsenceDate value
     * @param string $absenceDate
     * @return \StructType\DayCode_V2
     */
    public function setAbsenceDate($absenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($absenceDate) && !is_string($absenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absenceDate, true), gettype($absenceDate)), __LINE__);
        }
        $this->AbsenceDate = $absenceDate;
        return $this;
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\DayCode_V2
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get Amplitude value
     * @return float
     */
    public function getAmplitude()
    {
        return $this->Amplitude;
    }
    /**
     * Set Amplitude value
     * @param float $amplitude
     * @return \StructType\DayCode_V2
     */
    public function setAmplitude($amplitude = null)
    {
        // validation for constraint: float
        if (!is_null($amplitude) && !(is_float($amplitude) || is_numeric($amplitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amplitude, true), gettype($amplitude)), __LINE__);
        }
        $this->Amplitude = $amplitude;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DayCode_V2
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DayCode_V2
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TypeOfDayCode value
     * @return string|null
     */
    public function getTypeOfDayCode()
    {
        return $this->TypeOfDayCode;
    }
    /**
     * Set TypeOfDayCode value
     * @param string $typeOfDayCode
     * @return \StructType\DayCode_V2
     */
    public function setTypeOfDayCode($typeOfDayCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfDayCode) && !is_string($typeOfDayCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfDayCode, true), gettype($typeOfDayCode)), __LINE__);
        }
        $this->TypeOfDayCode = $typeOfDayCode;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \StructType\DayCode_V2
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get PayReference value
     * @return string|null
     */
    public function getPayReference()
    {
        return $this->PayReference;
    }
    /**
     * Set PayReference value
     * @param string $payReference
     * @return \StructType\DayCode_V2
     */
    public function setPayReference($payReference = null)
    {
        // validation for constraint: string
        if (!is_null($payReference) && !is_string($payReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payReference, true), gettype($payReference)), __LINE__);
        }
        $this->PayReference = $payReference;
        return $this;
    }
    /**
     * Get From1 value
     * @return string|null
     */
    public function getFrom1()
    {
        return $this->From1;
    }
    /**
     * Set From1 value
     * @param string $from1
     * @return \StructType\DayCode_V2
     */
    public function setFrom1($from1 = null)
    {
        // validation for constraint: string
        if (!is_null($from1) && !is_string($from1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from1, true), gettype($from1)), __LINE__);
        }
        $this->From1 = $from1;
        return $this;
    }
    /**
     * Get Until1 value
     * @return string|null
     */
    public function getUntil1()
    {
        return $this->Until1;
    }
    /**
     * Set Until1 value
     * @param string $until1
     * @return \StructType\DayCode_V2
     */
    public function setUntil1($until1 = null)
    {
        // validation for constraint: string
        if (!is_null($until1) && !is_string($until1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($until1, true), gettype($until1)), __LINE__);
        }
        $this->Until1 = $until1;
        return $this;
    }
    /**
     * Get From2 value
     * @return string|null
     */
    public function getFrom2()
    {
        return $this->From2;
    }
    /**
     * Set From2 value
     * @param string $from2
     * @return \StructType\DayCode_V2
     */
    public function setFrom2($from2 = null)
    {
        // validation for constraint: string
        if (!is_null($from2) && !is_string($from2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from2, true), gettype($from2)), __LINE__);
        }
        $this->From2 = $from2;
        return $this;
    }
    /**
     * Get Until2 value
     * @return string|null
     */
    public function getUntil2()
    {
        return $this->Until2;
    }
    /**
     * Set Until2 value
     * @param string $until2
     * @return \StructType\DayCode_V2
     */
    public function setUntil2($until2 = null)
    {
        // validation for constraint: string
        if (!is_null($until2) && !is_string($until2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($until2, true), gettype($until2)), __LINE__);
        }
        $this->Until2 = $until2;
        return $this;
    }
    /**
     * Get SocialCabinetDayCode value
     * @return string|null
     */
    public function getSocialCabinetDayCode()
    {
        return $this->SocialCabinetDayCode;
    }
    /**
     * Set SocialCabinetDayCode value
     * @param string $socialCabinetDayCode
     * @return \StructType\DayCode_V2
     */
    public function setSocialCabinetDayCode($socialCabinetDayCode = null)
    {
        // validation for constraint: string
        if (!is_null($socialCabinetDayCode) && !is_string($socialCabinetDayCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialCabinetDayCode, true), gettype($socialCabinetDayCode)), __LINE__);
        }
        $this->SocialCabinetDayCode = $socialCabinetDayCode;
        return $this;
    }
}
