<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayCode StructType
 * @subpackage Structs
 */
class DayCode extends AbstractStructBase
{
    /**
     * The EquivalentTimeDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EquivalentTimeDefault;
    /**
     * The ValidOnSaturday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ValidOnSaturday;
    /**
     * The ValidOnSunday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ValidOnSunday;
    /**
     * The Amplitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amplitude;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Regulation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Regulation;
    /**
     * The TypeOfDayCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfDayCode;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The PayReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReference;
    /**
     * The From1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From1;
    /**
     * The Untill1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Untill1;
    /**
     * The From2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From2;
    /**
     * The Untill2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Untill2;
    /**
     * Constructor method for DayCode
     * @uses DayCode::setEquivalentTimeDefault()
     * @uses DayCode::setValidOnSaturday()
     * @uses DayCode::setValidOnSunday()
     * @uses DayCode::setAmplitude()
     * @uses DayCode::setCode()
     * @uses DayCode::setDescription()
     * @uses DayCode::setRegulation()
     * @uses DayCode::setTypeOfDayCode()
     * @uses DayCode::setExternalReference()
     * @uses DayCode::setPayReference()
     * @uses DayCode::setFrom1()
     * @uses DayCode::setUntill1()
     * @uses DayCode::setFrom2()
     * @uses DayCode::setUntill2()
     * @param float $equivalentTimeDefault
     * @param bool $validOnSaturday
     * @param bool $validOnSunday
     * @param float $amplitude
     * @param string $code
     * @param string $description
     * @param string $regulation
     * @param string $typeOfDayCode
     * @param string $externalReference
     * @param string $payReference
     * @param string $from1
     * @param string $untill1
     * @param string $from2
     * @param string $untill2
     */
    public function __construct($equivalentTimeDefault = null, $validOnSaturday = null, $validOnSunday = null, $amplitude = null, $code = null, $description = null, $regulation = null, $typeOfDayCode = null, $externalReference = null, $payReference = null, $from1 = null, $untill1 = null, $from2 = null, $untill2 = null)
    {
        $this
            ->setEquivalentTimeDefault($equivalentTimeDefault)
            ->setValidOnSaturday($validOnSaturday)
            ->setValidOnSunday($validOnSunday)
            ->setAmplitude($amplitude)
            ->setCode($code)
            ->setDescription($description)
            ->setRegulation($regulation)
            ->setTypeOfDayCode($typeOfDayCode)
            ->setExternalReference($externalReference)
            ->setPayReference($payReference)
            ->setFrom1($from1)
            ->setUntill1($untill1)
            ->setFrom2($from2)
            ->setUntill2($untill2);
    }
    /**
     * Get EquivalentTimeDefault value
     * @return float
     */
    public function getEquivalentTimeDefault()
    {
        return $this->EquivalentTimeDefault;
    }
    /**
     * Set EquivalentTimeDefault value
     * @param float $equivalentTimeDefault
     * @return \StructType\DayCode
     */
    public function setEquivalentTimeDefault($equivalentTimeDefault = null)
    {
        // validation for constraint: float
        if (!is_null($equivalentTimeDefault) && !(is_float($equivalentTimeDefault) || is_numeric($equivalentTimeDefault))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($equivalentTimeDefault, true), gettype($equivalentTimeDefault)), __LINE__);
        }
        $this->EquivalentTimeDefault = $equivalentTimeDefault;
        return $this;
    }
    /**
     * Get ValidOnSaturday value
     * @return bool
     */
    public function getValidOnSaturday()
    {
        return $this->ValidOnSaturday;
    }
    /**
     * Set ValidOnSaturday value
     * @param bool $validOnSaturday
     * @return \StructType\DayCode
     */
    public function setValidOnSaturday($validOnSaturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($validOnSaturday) && !is_bool($validOnSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validOnSaturday, true), gettype($validOnSaturday)), __LINE__);
        }
        $this->ValidOnSaturday = $validOnSaturday;
        return $this;
    }
    /**
     * Get ValidOnSunday value
     * @return bool
     */
    public function getValidOnSunday()
    {
        return $this->ValidOnSunday;
    }
    /**
     * Set ValidOnSunday value
     * @param bool $validOnSunday
     * @return \StructType\DayCode
     */
    public function setValidOnSunday($validOnSunday = null)
    {
        // validation for constraint: boolean
        if (!is_null($validOnSunday) && !is_bool($validOnSunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validOnSunday, true), gettype($validOnSunday)), __LINE__);
        }
        $this->ValidOnSunday = $validOnSunday;
        return $this;
    }
    /**
     * Get Amplitude value
     * @return float
     */
    public function getAmplitude()
    {
        return $this->Amplitude;
    }
    /**
     * Set Amplitude value
     * @param float $amplitude
     * @return \StructType\DayCode
     */
    public function setAmplitude($amplitude = null)
    {
        // validation for constraint: float
        if (!is_null($amplitude) && !(is_float($amplitude) || is_numeric($amplitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amplitude, true), gettype($amplitude)), __LINE__);
        }
        $this->Amplitude = $amplitude;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DayCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DayCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Regulation value
     * @return string|null
     */
    public function getRegulation()
    {
        return $this->Regulation;
    }
    /**
     * Set Regulation value
     * @param string $regulation
     * @return \StructType\DayCode
     */
    public function setRegulation($regulation = null)
    {
        // validation for constraint: string
        if (!is_null($regulation) && !is_string($regulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulation, true), gettype($regulation)), __LINE__);
        }
        $this->Regulation = $regulation;
        return $this;
    }
    /**
     * Get TypeOfDayCode value
     * @return string|null
     */
    public function getTypeOfDayCode()
    {
        return $this->TypeOfDayCode;
    }
    /**
     * Set TypeOfDayCode value
     * @param string $typeOfDayCode
     * @return \StructType\DayCode
     */
    public function setTypeOfDayCode($typeOfDayCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfDayCode) && !is_string($typeOfDayCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfDayCode, true), gettype($typeOfDayCode)), __LINE__);
        }
        $this->TypeOfDayCode = $typeOfDayCode;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \StructType\DayCode
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get PayReference value
     * @return string|null
     */
    public function getPayReference()
    {
        return $this->PayReference;
    }
    /**
     * Set PayReference value
     * @param string $payReference
     * @return \StructType\DayCode
     */
    public function setPayReference($payReference = null)
    {
        // validation for constraint: string
        if (!is_null($payReference) && !is_string($payReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payReference, true), gettype($payReference)), __LINE__);
        }
        $this->PayReference = $payReference;
        return $this;
    }
    /**
     * Get From1 value
     * @return string|null
     */
    public function getFrom1()
    {
        return $this->From1;
    }
    /**
     * Set From1 value
     * @param string $from1
     * @return \StructType\DayCode
     */
    public function setFrom1($from1 = null)
    {
        // validation for constraint: string
        if (!is_null($from1) && !is_string($from1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from1, true), gettype($from1)), __LINE__);
        }
        $this->From1 = $from1;
        return $this;
    }
    /**
     * Get Untill1 value
     * @return string|null
     */
    public function getUntill1()
    {
        return $this->Untill1;
    }
    /**
     * Set Untill1 value
     * @param string $untill1
     * @return \StructType\DayCode
     */
    public function setUntill1($untill1 = null)
    {
        // validation for constraint: string
        if (!is_null($untill1) && !is_string($untill1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untill1, true), gettype($untill1)), __LINE__);
        }
        $this->Untill1 = $untill1;
        return $this;
    }
    /**
     * Get From2 value
     * @return string|null
     */
    public function getFrom2()
    {
        return $this->From2;
    }
    /**
     * Set From2 value
     * @param string $from2
     * @return \StructType\DayCode
     */
    public function setFrom2($from2 = null)
    {
        // validation for constraint: string
        if (!is_null($from2) && !is_string($from2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from2, true), gettype($from2)), __LINE__);
        }
        $this->From2 = $from2;
        return $this;
    }
    /**
     * Get Untill2 value
     * @return string|null
     */
    public function getUntill2()
    {
        return $this->Untill2;
    }
    /**
     * Set Untill2 value
     * @param string $untill2
     * @return \StructType\DayCode
     */
    public function setUntill2($untill2 = null)
    {
        // validation for constraint: string
        if (!is_null($untill2) && !is_string($untill2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untill2, true), gettype($untill2)), __LINE__);
        }
        $this->Untill2 = $untill2;
        return $this;
    }
}
