<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataType StructType
 * @subpackage Structs
 */
class DataType extends CodeInfo
{
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Length;
    /**
     * The Decimals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Decimals;
    /**
     * The Digits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Digits;
    /**
     * Constructor method for DataType
     * @uses DataType::setLength()
     * @uses DataType::setDecimals()
     * @uses DataType::setDigits()
     * @param int $length
     * @param int $decimals
     * @param int $digits
     */
    public function __construct($length = null, $decimals = null, $digits = null)
    {
        $this
            ->setLength($length)
            ->setDecimals($decimals)
            ->setDigits($digits);
    }
    /**
     * Get Length value
     * @return int
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\DataType
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Decimals value
     * @return int
     */
    public function getDecimals()
    {
        return $this->Decimals;
    }
    /**
     * Set Decimals value
     * @param int $decimals
     * @return \StructType\DataType
     */
    public function setDecimals($decimals = null)
    {
        // validation for constraint: int
        if (!is_null($decimals) && !(is_int($decimals) || ctype_digit($decimals))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimals, true), gettype($decimals)), __LINE__);
        }
        $this->Decimals = $decimals;
        return $this;
    }
    /**
     * Get Digits value
     * @return int
     */
    public function getDigits()
    {
        return $this->Digits;
    }
    /**
     * Set Digits value
     * @param int $digits
     * @return \StructType\DataType
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: int
        if (!is_null($digits) && !(is_int($digits) || ctype_digit($digits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($digits, true), gettype($digits)), __LINE__);
        }
        $this->Digits = $digits;
        return $this;
    }
}
