<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCompensationCode_V3 StructType
 * @subpackage Structs
 */
class CostCompensationCode_V3 extends CodeInfo
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The PayReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReference;
    /**
     * Constructor method for CostCompensationCode_V3
     * @uses CostCompensationCode_V3::setOrigin()
     * @uses CostCompensationCode_V3::setExternalReference()
     * @uses CostCompensationCode_V3::setPayReference()
     * @param string $origin
     * @param string $externalReference
     * @param string $payReference
     */
    public function __construct($origin = null, $externalReference = null, $payReference = null)
    {
        $this
            ->setOrigin($origin)
            ->setExternalReference($externalReference)
            ->setPayReference($payReference);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\CostCompensationCode_V3
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \StructType\CostCompensationCode_V3
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get PayReference value
     * @return string|null
     */
    public function getPayReference()
    {
        return $this->PayReference;
    }
    /**
     * Set PayReference value
     * @param string $payReference
     * @return \StructType\CostCompensationCode_V3
     */
    public function setPayReference($payReference = null)
    {
        // validation for constraint: string
        if (!is_null($payReference) && !is_string($payReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payReference, true), gettype($payReference)), __LINE__);
        }
        $this->PayReference = $payReference;
        return $this;
    }
}
