<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumptionReportItem StructType
 * @subpackage Structs
 */
class ConsumptionReportItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Distance;
    /**
     * The ConfidenceIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfidenceIndicator;
    /**
     * The Consumption_Driving_Avg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Driving_Avg;
    /**
     * The Consumption_Total_Avg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Total_Avg;
    /**
     * The Consumption_Trend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Trend;
    /**
     * The Consumption_Idle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Idle;
    /**
     * The Consumption_Driving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Driving;
    /**
     * The Consumption_Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Total;
    /**
     * The Consumption_Idle_pct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Consumption_Idle_pct;
    /**
     * The Speed_Avg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Speed_Avg;
    /**
     * The Emission_Idle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Emission_Idle;
    /**
     * The Emission_Driving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Emission_Driving;
    /**
     * The Emission_Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Emission_Total;
    /**
     * The Emission_Driving_Avg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Emission_Driving_Avg;
    /**
     * The Emission_Total_Avg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Emission_Total_Avg;
    /**
     * The Duration_Idle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration_Idle;
    /**
     * The Duration_Driving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration_Driving;
    /**
     * The Duration_Engine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration_Engine;
    /**
     * The Duration_Idle_Pct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration_Idle_Pct;
    /**
     * The Duration_Driving_Pct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration_Driving_Pct;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * Constructor method for ConsumptionReportItem
     * @uses ConsumptionReportItem::setDate()
     * @uses ConsumptionReportItem::setDistance()
     * @uses ConsumptionReportItem::setConfidenceIndicator()
     * @uses ConsumptionReportItem::setConsumption_Driving_Avg()
     * @uses ConsumptionReportItem::setConsumption_Total_Avg()
     * @uses ConsumptionReportItem::setConsumption_Trend()
     * @uses ConsumptionReportItem::setConsumption_Idle()
     * @uses ConsumptionReportItem::setConsumption_Driving()
     * @uses ConsumptionReportItem::setConsumption_Total()
     * @uses ConsumptionReportItem::setConsumption_Idle_pct()
     * @uses ConsumptionReportItem::setSpeed_Avg()
     * @uses ConsumptionReportItem::setEmission_Idle()
     * @uses ConsumptionReportItem::setEmission_Driving()
     * @uses ConsumptionReportItem::setEmission_Total()
     * @uses ConsumptionReportItem::setEmission_Driving_Avg()
     * @uses ConsumptionReportItem::setEmission_Total_Avg()
     * @uses ConsumptionReportItem::setDuration_Idle()
     * @uses ConsumptionReportItem::setDuration_Driving()
     * @uses ConsumptionReportItem::setDuration_Engine()
     * @uses ConsumptionReportItem::setDuration_Idle_Pct()
     * @uses ConsumptionReportItem::setDuration_Driving_Pct()
     * @uses ConsumptionReportItem::setVehicle()
     * @uses ConsumptionReportItem::setDriver()
     * @param string $date
     * @param int $distance
     * @param int $confidenceIndicator
     * @param float $consumption_Driving_Avg
     * @param float $consumption_Total_Avg
     * @param float $consumption_Trend
     * @param float $consumption_Idle
     * @param float $consumption_Driving
     * @param float $consumption_Total
     * @param float $consumption_Idle_pct
     * @param float $speed_Avg
     * @param float $emission_Idle
     * @param float $emission_Driving
     * @param float $emission_Total
     * @param float $emission_Driving_Avg
     * @param float $emission_Total_Avg
     * @param float $duration_Idle
     * @param float $duration_Driving
     * @param float $duration_Engine
     * @param float $duration_Idle_Pct
     * @param float $duration_Driving_Pct
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     */
    public function __construct($date = null, $distance = null, $confidenceIndicator = null, $consumption_Driving_Avg = null, $consumption_Total_Avg = null, $consumption_Trend = null, $consumption_Idle = null, $consumption_Driving = null, $consumption_Total = null, $consumption_Idle_pct = null, $speed_Avg = null, $emission_Idle = null, $emission_Driving = null, $emission_Total = null, $emission_Driving_Avg = null, $emission_Total_Avg = null, $duration_Idle = null, $duration_Driving = null, $duration_Engine = null, $duration_Idle_Pct = null, $duration_Driving_Pct = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null)
    {
        $this
            ->setDate($date)
            ->setDistance($distance)
            ->setConfidenceIndicator($confidenceIndicator)
            ->setConsumption_Driving_Avg($consumption_Driving_Avg)
            ->setConsumption_Total_Avg($consumption_Total_Avg)
            ->setConsumption_Trend($consumption_Trend)
            ->setConsumption_Idle($consumption_Idle)
            ->setConsumption_Driving($consumption_Driving)
            ->setConsumption_Total($consumption_Total)
            ->setConsumption_Idle_pct($consumption_Idle_pct)
            ->setSpeed_Avg($speed_Avg)
            ->setEmission_Idle($emission_Idle)
            ->setEmission_Driving($emission_Driving)
            ->setEmission_Total($emission_Total)
            ->setEmission_Driving_Avg($emission_Driving_Avg)
            ->setEmission_Total_Avg($emission_Total_Avg)
            ->setDuration_Idle($duration_Idle)
            ->setDuration_Driving($duration_Driving)
            ->setDuration_Engine($duration_Engine)
            ->setDuration_Idle_Pct($duration_Idle_Pct)
            ->setDuration_Driving_Pct($duration_Driving_Pct)
            ->setVehicle($vehicle)
            ->setDriver($driver);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ConsumptionReportItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\ConsumptionReportItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get ConfidenceIndicator value
     * @return int
     */
    public function getConfidenceIndicator()
    {
        return $this->ConfidenceIndicator;
    }
    /**
     * Set ConfidenceIndicator value
     * @param int $confidenceIndicator
     * @return \StructType\ConsumptionReportItem
     */
    public function setConfidenceIndicator($confidenceIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($confidenceIndicator) && !(is_int($confidenceIndicator) || ctype_digit($confidenceIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confidenceIndicator, true), gettype($confidenceIndicator)), __LINE__);
        }
        $this->ConfidenceIndicator = $confidenceIndicator;
        return $this;
    }
    /**
     * Get Consumption_Driving_Avg value
     * @return float
     */
    public function getConsumption_Driving_Avg()
    {
        return $this->Consumption_Driving_Avg;
    }
    /**
     * Set Consumption_Driving_Avg value
     * @param float $consumption_Driving_Avg
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Driving_Avg($consumption_Driving_Avg = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Driving_Avg) && !(is_float($consumption_Driving_Avg) || is_numeric($consumption_Driving_Avg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Driving_Avg, true), gettype($consumption_Driving_Avg)), __LINE__);
        }
        $this->Consumption_Driving_Avg = $consumption_Driving_Avg;
        return $this;
    }
    /**
     * Get Consumption_Total_Avg value
     * @return float
     */
    public function getConsumption_Total_Avg()
    {
        return $this->Consumption_Total_Avg;
    }
    /**
     * Set Consumption_Total_Avg value
     * @param float $consumption_Total_Avg
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Total_Avg($consumption_Total_Avg = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Total_Avg) && !(is_float($consumption_Total_Avg) || is_numeric($consumption_Total_Avg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Total_Avg, true), gettype($consumption_Total_Avg)), __LINE__);
        }
        $this->Consumption_Total_Avg = $consumption_Total_Avg;
        return $this;
    }
    /**
     * Get Consumption_Trend value
     * @return float
     */
    public function getConsumption_Trend()
    {
        return $this->Consumption_Trend;
    }
    /**
     * Set Consumption_Trend value
     * @param float $consumption_Trend
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Trend($consumption_Trend = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Trend) && !(is_float($consumption_Trend) || is_numeric($consumption_Trend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Trend, true), gettype($consumption_Trend)), __LINE__);
        }
        $this->Consumption_Trend = $consumption_Trend;
        return $this;
    }
    /**
     * Get Consumption_Idle value
     * @return float
     */
    public function getConsumption_Idle()
    {
        return $this->Consumption_Idle;
    }
    /**
     * Set Consumption_Idle value
     * @param float $consumption_Idle
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Idle($consumption_Idle = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Idle) && !(is_float($consumption_Idle) || is_numeric($consumption_Idle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Idle, true), gettype($consumption_Idle)), __LINE__);
        }
        $this->Consumption_Idle = $consumption_Idle;
        return $this;
    }
    /**
     * Get Consumption_Driving value
     * @return float
     */
    public function getConsumption_Driving()
    {
        return $this->Consumption_Driving;
    }
    /**
     * Set Consumption_Driving value
     * @param float $consumption_Driving
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Driving($consumption_Driving = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Driving) && !(is_float($consumption_Driving) || is_numeric($consumption_Driving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Driving, true), gettype($consumption_Driving)), __LINE__);
        }
        $this->Consumption_Driving = $consumption_Driving;
        return $this;
    }
    /**
     * Get Consumption_Total value
     * @return float
     */
    public function getConsumption_Total()
    {
        return $this->Consumption_Total;
    }
    /**
     * Set Consumption_Total value
     * @param float $consumption_Total
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Total($consumption_Total = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Total) && !(is_float($consumption_Total) || is_numeric($consumption_Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Total, true), gettype($consumption_Total)), __LINE__);
        }
        $this->Consumption_Total = $consumption_Total;
        return $this;
    }
    /**
     * Get Consumption_Idle_pct value
     * @return float
     */
    public function getConsumption_Idle_pct()
    {
        return $this->Consumption_Idle_pct;
    }
    /**
     * Set Consumption_Idle_pct value
     * @param float $consumption_Idle_pct
     * @return \StructType\ConsumptionReportItem
     */
    public function setConsumption_Idle_pct($consumption_Idle_pct = null)
    {
        // validation for constraint: float
        if (!is_null($consumption_Idle_pct) && !(is_float($consumption_Idle_pct) || is_numeric($consumption_Idle_pct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumption_Idle_pct, true), gettype($consumption_Idle_pct)), __LINE__);
        }
        $this->Consumption_Idle_pct = $consumption_Idle_pct;
        return $this;
    }
    /**
     * Get Speed_Avg value
     * @return float
     */
    public function getSpeed_Avg()
    {
        return $this->Speed_Avg;
    }
    /**
     * Set Speed_Avg value
     * @param float $speed_Avg
     * @return \StructType\ConsumptionReportItem
     */
    public function setSpeed_Avg($speed_Avg = null)
    {
        // validation for constraint: float
        if (!is_null($speed_Avg) && !(is_float($speed_Avg) || is_numeric($speed_Avg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speed_Avg, true), gettype($speed_Avg)), __LINE__);
        }
        $this->Speed_Avg = $speed_Avg;
        return $this;
    }
    /**
     * Get Emission_Idle value
     * @return float
     */
    public function getEmission_Idle()
    {
        return $this->Emission_Idle;
    }
    /**
     * Set Emission_Idle value
     * @param float $emission_Idle
     * @return \StructType\ConsumptionReportItem
     */
    public function setEmission_Idle($emission_Idle = null)
    {
        // validation for constraint: float
        if (!is_null($emission_Idle) && !(is_float($emission_Idle) || is_numeric($emission_Idle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emission_Idle, true), gettype($emission_Idle)), __LINE__);
        }
        $this->Emission_Idle = $emission_Idle;
        return $this;
    }
    /**
     * Get Emission_Driving value
     * @return float
     */
    public function getEmission_Driving()
    {
        return $this->Emission_Driving;
    }
    /**
     * Set Emission_Driving value
     * @param float $emission_Driving
     * @return \StructType\ConsumptionReportItem
     */
    public function setEmission_Driving($emission_Driving = null)
    {
        // validation for constraint: float
        if (!is_null($emission_Driving) && !(is_float($emission_Driving) || is_numeric($emission_Driving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emission_Driving, true), gettype($emission_Driving)), __LINE__);
        }
        $this->Emission_Driving = $emission_Driving;
        return $this;
    }
    /**
     * Get Emission_Total value
     * @return float
     */
    public function getEmission_Total()
    {
        return $this->Emission_Total;
    }
    /**
     * Set Emission_Total value
     * @param float $emission_Total
     * @return \StructType\ConsumptionReportItem
     */
    public function setEmission_Total($emission_Total = null)
    {
        // validation for constraint: float
        if (!is_null($emission_Total) && !(is_float($emission_Total) || is_numeric($emission_Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emission_Total, true), gettype($emission_Total)), __LINE__);
        }
        $this->Emission_Total = $emission_Total;
        return $this;
    }
    /**
     * Get Emission_Driving_Avg value
     * @return float
     */
    public function getEmission_Driving_Avg()
    {
        return $this->Emission_Driving_Avg;
    }
    /**
     * Set Emission_Driving_Avg value
     * @param float $emission_Driving_Avg
     * @return \StructType\ConsumptionReportItem
     */
    public function setEmission_Driving_Avg($emission_Driving_Avg = null)
    {
        // validation for constraint: float
        if (!is_null($emission_Driving_Avg) && !(is_float($emission_Driving_Avg) || is_numeric($emission_Driving_Avg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emission_Driving_Avg, true), gettype($emission_Driving_Avg)), __LINE__);
        }
        $this->Emission_Driving_Avg = $emission_Driving_Avg;
        return $this;
    }
    /**
     * Get Emission_Total_Avg value
     * @return float
     */
    public function getEmission_Total_Avg()
    {
        return $this->Emission_Total_Avg;
    }
    /**
     * Set Emission_Total_Avg value
     * @param float $emission_Total_Avg
     * @return \StructType\ConsumptionReportItem
     */
    public function setEmission_Total_Avg($emission_Total_Avg = null)
    {
        // validation for constraint: float
        if (!is_null($emission_Total_Avg) && !(is_float($emission_Total_Avg) || is_numeric($emission_Total_Avg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($emission_Total_Avg, true), gettype($emission_Total_Avg)), __LINE__);
        }
        $this->Emission_Total_Avg = $emission_Total_Avg;
        return $this;
    }
    /**
     * Get Duration_Idle value
     * @return float
     */
    public function getDuration_Idle()
    {
        return $this->Duration_Idle;
    }
    /**
     * Set Duration_Idle value
     * @param float $duration_Idle
     * @return \StructType\ConsumptionReportItem
     */
    public function setDuration_Idle($duration_Idle = null)
    {
        // validation for constraint: float
        if (!is_null($duration_Idle) && !(is_float($duration_Idle) || is_numeric($duration_Idle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration_Idle, true), gettype($duration_Idle)), __LINE__);
        }
        $this->Duration_Idle = $duration_Idle;
        return $this;
    }
    /**
     * Get Duration_Driving value
     * @return float
     */
    public function getDuration_Driving()
    {
        return $this->Duration_Driving;
    }
    /**
     * Set Duration_Driving value
     * @param float $duration_Driving
     * @return \StructType\ConsumptionReportItem
     */
    public function setDuration_Driving($duration_Driving = null)
    {
        // validation for constraint: float
        if (!is_null($duration_Driving) && !(is_float($duration_Driving) || is_numeric($duration_Driving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration_Driving, true), gettype($duration_Driving)), __LINE__);
        }
        $this->Duration_Driving = $duration_Driving;
        return $this;
    }
    /**
     * Get Duration_Engine value
     * @return float
     */
    public function getDuration_Engine()
    {
        return $this->Duration_Engine;
    }
    /**
     * Set Duration_Engine value
     * @param float $duration_Engine
     * @return \StructType\ConsumptionReportItem
     */
    public function setDuration_Engine($duration_Engine = null)
    {
        // validation for constraint: float
        if (!is_null($duration_Engine) && !(is_float($duration_Engine) || is_numeric($duration_Engine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration_Engine, true), gettype($duration_Engine)), __LINE__);
        }
        $this->Duration_Engine = $duration_Engine;
        return $this;
    }
    /**
     * Get Duration_Idle_Pct value
     * @return float
     */
    public function getDuration_Idle_Pct()
    {
        return $this->Duration_Idle_Pct;
    }
    /**
     * Set Duration_Idle_Pct value
     * @param float $duration_Idle_Pct
     * @return \StructType\ConsumptionReportItem
     */
    public function setDuration_Idle_Pct($duration_Idle_Pct = null)
    {
        // validation for constraint: float
        if (!is_null($duration_Idle_Pct) && !(is_float($duration_Idle_Pct) || is_numeric($duration_Idle_Pct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration_Idle_Pct, true), gettype($duration_Idle_Pct)), __LINE__);
        }
        $this->Duration_Idle_Pct = $duration_Idle_Pct;
        return $this;
    }
    /**
     * Get Duration_Driving_Pct value
     * @return float
     */
    public function getDuration_Driving_Pct()
    {
        return $this->Duration_Driving_Pct;
    }
    /**
     * Set Duration_Driving_Pct value
     * @param float $duration_Driving_Pct
     * @return \StructType\ConsumptionReportItem
     */
    public function setDuration_Driving_Pct($duration_Driving_Pct = null)
    {
        // validation for constraint: float
        if (!is_null($duration_Driving_Pct) && !(is_float($duration_Driving_Pct) || is_numeric($duration_Driving_Pct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration_Driving_Pct, true), gettype($duration_Driving_Pct)), __LINE__);
        }
        $this->Duration_Driving_Pct = $duration_Driving_Pct;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\ConsumptionReportItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\ConsumptionReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
