<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consultation StructType
 * @subpackage Structs
 */
class Consultation extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDate;
    /**
     * The LeavingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LeavingDate;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Km;
    /**
     * The ConsultationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ConsultationID;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for Consultation
     * @uses Consultation::setArrivalDate()
     * @uses Consultation::setLeavingDate()
     * @uses Consultation::setModificationDate()
     * @uses Consultation::setKm()
     * @uses Consultation::setConsultationID()
     * @uses Consultation::setActivity()
     * @uses Consultation::setPlace()
     * @uses Consultation::setTrip()
     * @uses Consultation::setVehicle()
     * @uses Consultation::setDriver()
     * @uses Consultation::setPosition()
     * @param string $arrivalDate
     * @param string $leavingDate
     * @param string $modificationDate
     * @param int $km
     * @param int $consultationID
     * @param \StructType\Activity $activity
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\Position $position
     */
    public function __construct($arrivalDate = null, $leavingDate = null, $modificationDate = null, $km = null, $consultationID = null, \StructType\Activity $activity = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, \StructType\Position $position = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setLeavingDate($leavingDate)
            ->setModificationDate($modificationDate)
            ->setKm($km)
            ->setConsultationID($consultationID)
            ->setActivity($activity)
            ->setPlace($place)
            ->setTrip($trip)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setPosition($position);
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\Consultation
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get LeavingDate value
     * @return string
     */
    public function getLeavingDate()
    {
        return $this->LeavingDate;
    }
    /**
     * Set LeavingDate value
     * @param string $leavingDate
     * @return \StructType\Consultation
     */
    public function setLeavingDate($leavingDate = null)
    {
        // validation for constraint: string
        if (!is_null($leavingDate) && !is_string($leavingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leavingDate, true), gettype($leavingDate)), __LINE__);
        }
        $this->LeavingDate = $leavingDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\Consultation
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Km value
     * @return int
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param int $km
     * @return \StructType\Consultation
     */
    public function setKm($km = null)
    {
        // validation for constraint: int
        if (!is_null($km) && !(is_int($km) || ctype_digit($km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($km, true), gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Get ConsultationID value
     * @return int
     */
    public function getConsultationID()
    {
        return $this->ConsultationID;
    }
    /**
     * Set ConsultationID value
     * @param int $consultationID
     * @return \StructType\Consultation
     */
    public function setConsultationID($consultationID = null)
    {
        // validation for constraint: int
        if (!is_null($consultationID) && !(is_int($consultationID) || ctype_digit($consultationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consultationID, true), gettype($consultationID)), __LINE__);
        }
        $this->ConsultationID = $consultationID;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Consultation
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\Consultation
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\Consultation
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\Consultation
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\Consultation
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\Consultation
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
