<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyPOISubGroupItem StructType
 * @subpackage Structs
 */
class CompanyPOISubGroupItem extends AbstractStructBase
{
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The SubGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupName;
    /**
     * The CompanyPOIList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPOIBase
     */
    public $CompanyPOIList;
    /**
     * Constructor method for CompanyPOISubGroupItem
     * @uses CompanyPOISubGroupItem::setSubGroupCode()
     * @uses CompanyPOISubGroupItem::setSubGroupName()
     * @uses CompanyPOISubGroupItem::setCompanyPOIList()
     * @param string $subGroupCode
     * @param string $subGroupName
     * @param \ArrayType\ArrayOfPOIBase $companyPOIList
     */
    public function __construct($subGroupCode = null, $subGroupName = null, \ArrayType\ArrayOfPOIBase $companyPOIList = null)
    {
        $this
            ->setSubGroupCode($subGroupCode)
            ->setSubGroupName($subGroupName)
            ->setCompanyPOIList($companyPOIList);
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\CompanyPOISubGroupItem
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get SubGroupName value
     * @return string|null
     */
    public function getSubGroupName()
    {
        return $this->SubGroupName;
    }
    /**
     * Set SubGroupName value
     * @param string $subGroupName
     * @return \StructType\CompanyPOISubGroupItem
     */
    public function setSubGroupName($subGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupName) && !is_string($subGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupName, true), gettype($subGroupName)), __LINE__);
        }
        $this->SubGroupName = $subGroupName;
        return $this;
    }
    /**
     * Get CompanyPOIList value
     * @return \ArrayType\ArrayOfPOIBase|null
     */
    public function getCompanyPOIList()
    {
        return $this->CompanyPOIList;
    }
    /**
     * Set CompanyPOIList value
     * @param \ArrayType\ArrayOfPOIBase $companyPOIList
     * @return \StructType\CompanyPOISubGroupItem
     */
    public function setCompanyPOIList(\ArrayType\ArrayOfPOIBase $companyPOIList = null)
    {
        $this->CompanyPOIList = $companyPOIList;
        return $this;
    }
}
