<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Answer StructType
 * @subpackage Structs
 */
class Answer extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The NextPathSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NextPathSequence;
    /**
     * The TreatmentCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $TreatmentCodes;
    /**
     * The AnomalyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $AnomalyCode;
    /**
     * The ExtraInfoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $ExtraInfoCode;
    /**
     * The PalletCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $PalletCode;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $CostCode;
    /**
     * The CompensationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $CompensationCode;
    /**
     * The DataType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataType
     */
    public $DataType;
    /**
     * Constructor method for Answer
     * @uses Answer::setID()
     * @uses Answer::setValue()
     * @uses Answer::setNextPathSequence()
     * @uses Answer::setTreatmentCodes()
     * @uses Answer::setAnomalyCode()
     * @uses Answer::setExtraInfoCode()
     * @uses Answer::setPalletCode()
     * @uses Answer::setCostCode()
     * @uses Answer::setCompensationCode()
     * @uses Answer::setDataType()
     * @param string $iD
     * @param string $value
     * @param string $nextPathSequence
     * @param \ArrayType\ArrayOfCodeInfo $treatmentCodes
     * @param \StructType\CodeInfo $anomalyCode
     * @param \StructType\CodeInfo $extraInfoCode
     * @param \StructType\CodeInfo $palletCode
     * @param \StructType\CodeInfo $costCode
     * @param \StructType\CodeInfo $compensationCode
     * @param \StructType\DataType $dataType
     */
    public function __construct($iD = null, $value = null, $nextPathSequence = null, \ArrayType\ArrayOfCodeInfo $treatmentCodes = null, \StructType\CodeInfo $anomalyCode = null, \StructType\CodeInfo $extraInfoCode = null, \StructType\CodeInfo $palletCode = null, \StructType\CodeInfo $costCode = null, \StructType\CodeInfo $compensationCode = null, \StructType\DataType $dataType = null)
    {
        $this
            ->setID($iD)
            ->setValue($value)
            ->setNextPathSequence($nextPathSequence)
            ->setTreatmentCodes($treatmentCodes)
            ->setAnomalyCode($anomalyCode)
            ->setExtraInfoCode($extraInfoCode)
            ->setPalletCode($palletCode)
            ->setCostCode($costCode)
            ->setCompensationCode($compensationCode)
            ->setDataType($dataType);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Answer
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Answer
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get NextPathSequence value
     * @return string|null
     */
    public function getNextPathSequence()
    {
        return $this->NextPathSequence;
    }
    /**
     * Set NextPathSequence value
     * @param string $nextPathSequence
     * @return \StructType\Answer
     */
    public function setNextPathSequence($nextPathSequence = null)
    {
        // validation for constraint: string
        if (!is_null($nextPathSequence) && !is_string($nextPathSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextPathSequence, true), gettype($nextPathSequence)), __LINE__);
        }
        $this->NextPathSequence = $nextPathSequence;
        return $this;
    }
    /**
     * Get TreatmentCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getTreatmentCodes()
    {
        return $this->TreatmentCodes;
    }
    /**
     * Set TreatmentCodes value
     * @param \ArrayType\ArrayOfCodeInfo $treatmentCodes
     * @return \StructType\Answer
     */
    public function setTreatmentCodes(\ArrayType\ArrayOfCodeInfo $treatmentCodes = null)
    {
        $this->TreatmentCodes = $treatmentCodes;
        return $this;
    }
    /**
     * Get AnomalyCode value
     * @return \StructType\CodeInfo|null
     */
    public function getAnomalyCode()
    {
        return $this->AnomalyCode;
    }
    /**
     * Set AnomalyCode value
     * @param \StructType\CodeInfo $anomalyCode
     * @return \StructType\Answer
     */
    public function setAnomalyCode(\StructType\CodeInfo $anomalyCode = null)
    {
        $this->AnomalyCode = $anomalyCode;
        return $this;
    }
    /**
     * Get ExtraInfoCode value
     * @return \StructType\CodeInfo|null
     */
    public function getExtraInfoCode()
    {
        return $this->ExtraInfoCode;
    }
    /**
     * Set ExtraInfoCode value
     * @param \StructType\CodeInfo $extraInfoCode
     * @return \StructType\Answer
     */
    public function setExtraInfoCode(\StructType\CodeInfo $extraInfoCode = null)
    {
        $this->ExtraInfoCode = $extraInfoCode;
        return $this;
    }
    /**
     * Get PalletCode value
     * @return \StructType\CodeInfo|null
     */
    public function getPalletCode()
    {
        return $this->PalletCode;
    }
    /**
     * Set PalletCode value
     * @param \StructType\CodeInfo $palletCode
     * @return \StructType\Answer
     */
    public function setPalletCode(\StructType\CodeInfo $palletCode = null)
    {
        $this->PalletCode = $palletCode;
        return $this;
    }
    /**
     * Get CostCode value
     * @return \StructType\CodeInfo|null
     */
    public function getCostCode()
    {
        return $this->CostCode;
    }
    /**
     * Set CostCode value
     * @param \StructType\CodeInfo $costCode
     * @return \StructType\Answer
     */
    public function setCostCode(\StructType\CodeInfo $costCode = null)
    {
        $this->CostCode = $costCode;
        return $this;
    }
    /**
     * Get CompensationCode value
     * @return \StructType\CodeInfo|null
     */
    public function getCompensationCode()
    {
        return $this->CompensationCode;
    }
    /**
     * Set CompensationCode value
     * @param \StructType\CodeInfo $compensationCode
     * @return \StructType\Answer
     */
    public function setCompensationCode(\StructType\CodeInfo $compensationCode = null)
    {
        $this->CompensationCode = $compensationCode;
        return $this;
    }
    /**
     * Get DataType value
     * @return \StructType\DataType|null
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @param \StructType\DataType $dataType
     * @return \StructType\Answer
     */
    public function setDataType(\StructType\DataType $dataType = null)
    {
        $this->DataType = $dataType;
        return $this;
    }
}
