<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlarmInfo StructType
 * @subpackage Structs
 */
class AlarmInfo extends AbstractStructBase
{
    /**
     * The TotalAlarms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalAlarms;
    /**
     * The TreatedAlarms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TreatedAlarms;
    /**
     * The UntreatedAlarms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UntreatedAlarms;
    /**
     * The UntreatedAlarmsSinceLastRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UntreatedAlarmsSinceLastRequest;
    /**
     * Constructor method for AlarmInfo
     * @uses AlarmInfo::setTotalAlarms()
     * @uses AlarmInfo::setTreatedAlarms()
     * @uses AlarmInfo::setUntreatedAlarms()
     * @uses AlarmInfo::setUntreatedAlarmsSinceLastRequest()
     * @param int $totalAlarms
     * @param int $treatedAlarms
     * @param int $untreatedAlarms
     * @param int $untreatedAlarmsSinceLastRequest
     */
    public function __construct($totalAlarms = null, $treatedAlarms = null, $untreatedAlarms = null, $untreatedAlarmsSinceLastRequest = null)
    {
        $this
            ->setTotalAlarms($totalAlarms)
            ->setTreatedAlarms($treatedAlarms)
            ->setUntreatedAlarms($untreatedAlarms)
            ->setUntreatedAlarmsSinceLastRequest($untreatedAlarmsSinceLastRequest);
    }
    /**
     * Get TotalAlarms value
     * @return int
     */
    public function getTotalAlarms()
    {
        return $this->TotalAlarms;
    }
    /**
     * Set TotalAlarms value
     * @param int $totalAlarms
     * @return \StructType\AlarmInfo
     */
    public function setTotalAlarms($totalAlarms = null)
    {
        // validation for constraint: int
        if (!is_null($totalAlarms) && !(is_int($totalAlarms) || ctype_digit($totalAlarms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAlarms, true), gettype($totalAlarms)), __LINE__);
        }
        $this->TotalAlarms = $totalAlarms;
        return $this;
    }
    /**
     * Get TreatedAlarms value
     * @return int
     */
    public function getTreatedAlarms()
    {
        return $this->TreatedAlarms;
    }
    /**
     * Set TreatedAlarms value
     * @param int $treatedAlarms
     * @return \StructType\AlarmInfo
     */
    public function setTreatedAlarms($treatedAlarms = null)
    {
        // validation for constraint: int
        if (!is_null($treatedAlarms) && !(is_int($treatedAlarms) || ctype_digit($treatedAlarms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($treatedAlarms, true), gettype($treatedAlarms)), __LINE__);
        }
        $this->TreatedAlarms = $treatedAlarms;
        return $this;
    }
    /**
     * Get UntreatedAlarms value
     * @return int
     */
    public function getUntreatedAlarms()
    {
        return $this->UntreatedAlarms;
    }
    /**
     * Set UntreatedAlarms value
     * @param int $untreatedAlarms
     * @return \StructType\AlarmInfo
     */
    public function setUntreatedAlarms($untreatedAlarms = null)
    {
        // validation for constraint: int
        if (!is_null($untreatedAlarms) && !(is_int($untreatedAlarms) || ctype_digit($untreatedAlarms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($untreatedAlarms, true), gettype($untreatedAlarms)), __LINE__);
        }
        $this->UntreatedAlarms = $untreatedAlarms;
        return $this;
    }
    /**
     * Get UntreatedAlarmsSinceLastRequest value
     * @return int
     */
    public function getUntreatedAlarmsSinceLastRequest()
    {
        return $this->UntreatedAlarmsSinceLastRequest;
    }
    /**
     * Set UntreatedAlarmsSinceLastRequest value
     * @param int $untreatedAlarmsSinceLastRequest
     * @return \StructType\AlarmInfo
     */
    public function setUntreatedAlarmsSinceLastRequest($untreatedAlarmsSinceLastRequest = null)
    {
        // validation for constraint: int
        if (!is_null($untreatedAlarmsSinceLastRequest) && !(is_int($untreatedAlarmsSinceLastRequest) || ctype_digit($untreatedAlarmsSinceLastRequest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($untreatedAlarmsSinceLastRequest, true), gettype($untreatedAlarmsSinceLastRequest)), __LINE__);
        }
        $this->UntreatedAlarmsSinceLastRequest = $untreatedAlarmsSinceLastRequest;
        return $this;
    }
}
