<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalRecipient StructType
 * @subpackage Structs
 */
class AdditionalRecipient extends AbstractStructBase
{
    /**
     * The AdditionalRecipientType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdditionalRecipientType;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * Constructor method for AdditionalRecipient
     * @uses AdditionalRecipient::setAdditionalRecipientType()
     * @uses AdditionalRecipient::setAddress()
     * @param string $additionalRecipientType
     * @param string $address
     */
    public function __construct($additionalRecipientType = null, $address = null)
    {
        $this
            ->setAdditionalRecipientType($additionalRecipientType)
            ->setAddress($address);
    }
    /**
     * Get AdditionalRecipientType value
     * @return string
     */
    public function getAdditionalRecipientType()
    {
        return $this->AdditionalRecipientType;
    }
    /**
     * Set AdditionalRecipientType value
     * @uses \EnumType\EnumAdditionalRecipientType::valueIsValid()
     * @uses \EnumType\EnumAdditionalRecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $additionalRecipientType
     * @return \StructType\AdditionalRecipient
     */
    public function setAdditionalRecipientType($additionalRecipientType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumAdditionalRecipientType::valueIsValid($additionalRecipientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumAdditionalRecipientType', is_array($additionalRecipientType) ? implode(', ', $additionalRecipientType) : var_export($additionalRecipientType, true), implode(', ', \EnumType\EnumAdditionalRecipientType::getValidValues())), __LINE__);
        }
        $this->AdditionalRecipientType = $additionalRecipientType;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\AdditionalRecipient
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
}
