<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityVersionResult_V5 StructType
 * @subpackage Structs
 */
class ActivityVersionResult_V5 extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Version;
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityInfo_V5
     */
    public $Activities;
    /**
     * Constructor method for ActivityVersionResult_V5
     * @uses ActivityVersionResult_V5::setVersion()
     * @uses ActivityVersionResult_V5::setActivities()
     * @param int $version
     * @param \ArrayType\ArrayOfActivityInfo_V5 $activities
     */
    public function __construct($version = null, \ArrayType\ArrayOfActivityInfo_V5 $activities = null)
    {
        $this
            ->setVersion($version)
            ->setActivities($activities);
    }
    /**
     * Get Version value
     * @return int
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \StructType\ActivityVersionResult_V5
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Activities value
     * @return \ArrayType\ArrayOfActivityInfo_V5|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \ArrayType\ArrayOfActivityInfo_V5 $activities
     * @return \StructType\ActivityVersionResult_V5
     */
    public function setActivities(\ArrayType\ArrayOfActivityInfo_V5 $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
}
