<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Import_ViaRoute_GPX
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Import_ViaRoute_GPX $parameters
     * @return \StructType\Import_ViaRoute_GPXResponse|bool
     */
    public function Import_ViaRoute_GPX(\StructType\Import_ViaRoute_GPX $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_ViaRoute_GPX($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Import_ViaRoute_GPXResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
