<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTripResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTripResult extends AbstractStructArrayBase
{
    /**
     * The TripResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TripResult[]
     */
    public $TripResult;
    /**
     * Constructor method for ArrayOfTripResult
     * @uses ArrayOfTripResult::setTripResult()
     * @param \StructType\TripResult[] $tripResult
     */
    public function __construct(array $tripResult = array())
    {
        $this
            ->setTripResult($tripResult);
    }
    /**
     * Get TripResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TripResult[]|null
     */
    public function getTripResult()
    {
        return isset($this->TripResult) ? $this->TripResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTripResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTripResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTripResultForArrayConstraintsFromSetTripResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTripResultTripResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTripResultTripResultItem instanceof \StructType\TripResult) {
                $invalidValues[] = is_object($arrayOfTripResultTripResultItem) ? get_class($arrayOfTripResultTripResultItem) : sprintf('%s(%s)', gettype($arrayOfTripResultTripResultItem), var_export($arrayOfTripResultTripResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TripResult property can only contain items of type \StructType\TripResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TripResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TripResult[] $tripResult
     * @return \ArrayType\ArrayOfTripResult
     */
    public function setTripResult(array $tripResult = array())
    {
        // validation for constraint: array
        if ('' !== ($tripResultArrayErrorMessage = self::validateTripResultForArrayConstraintsFromSetTripResult($tripResult))) {
            throw new \InvalidArgumentException($tripResultArrayErrorMessage, __LINE__);
        }
        if (is_null($tripResult) || (is_array($tripResult) && empty($tripResult))) {
            unset($this->TripResult);
        } else {
            $this->TripResult = $tripResult;
        }
        return $this;
    }
    /**
     * Add item to TripResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TripResult $item
     * @return \ArrayType\ArrayOfTripResult
     */
    public function addToTripResult(\StructType\TripResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripResult) {
            throw new \InvalidArgumentException(sprintf('The TripResult property can only contain items of type \StructType\TripResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TripResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TripResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TripResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TripResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TripResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TripResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TripResult
     */
    public function getAttributeName()
    {
        return 'TripResult';
    }
}
