<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTripItemResult_v3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfTripItemResult_v3 extends AbstractStructArrayBase
{
    /**
     * The TripItemResult_v3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TripItemResult_v3[]
     */
    public $TripItemResult_v3;
    /**
     * Constructor method for ArrayOfTripItemResult_v3
     * @uses ArrayOfTripItemResult_v3::setTripItemResult_v3()
     * @param \StructType\TripItemResult_v3[] $tripItemResult_v3
     */
    public function __construct(array $tripItemResult_v3 = array())
    {
        $this
            ->setTripItemResult_v3($tripItemResult_v3);
    }
    /**
     * Get TripItemResult_v3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TripItemResult_v3[]|null
     */
    public function getTripItemResult_v3()
    {
        return isset($this->TripItemResult_v3) ? $this->TripItemResult_v3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTripItemResult_v3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTripItemResult_v3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTripItemResult_v3ForArrayConstraintsFromSetTripItemResult_v3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTripItemResult_v3TripItemResult_v3Item) {
            // validation for constraint: itemType
            if (!$arrayOfTripItemResult_v3TripItemResult_v3Item instanceof \StructType\TripItemResult_v3) {
                $invalidValues[] = is_object($arrayOfTripItemResult_v3TripItemResult_v3Item) ? get_class($arrayOfTripItemResult_v3TripItemResult_v3Item) : sprintf('%s(%s)', gettype($arrayOfTripItemResult_v3TripItemResult_v3Item), var_export($arrayOfTripItemResult_v3TripItemResult_v3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TripItemResult_v3 property can only contain items of type \StructType\TripItemResult_v3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TripItemResult_v3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TripItemResult_v3[] $tripItemResult_v3
     * @return \ArrayType\ArrayOfTripItemResult_v3
     */
    public function setTripItemResult_v3(array $tripItemResult_v3 = array())
    {
        // validation for constraint: array
        if ('' !== ($tripItemResult_v3ArrayErrorMessage = self::validateTripItemResult_v3ForArrayConstraintsFromSetTripItemResult_v3($tripItemResult_v3))) {
            throw new \InvalidArgumentException($tripItemResult_v3ArrayErrorMessage, __LINE__);
        }
        if (is_null($tripItemResult_v3) || (is_array($tripItemResult_v3) && empty($tripItemResult_v3))) {
            unset($this->TripItemResult_v3);
        } else {
            $this->TripItemResult_v3 = $tripItemResult_v3;
        }
        return $this;
    }
    /**
     * Add item to TripItemResult_v3 value
     * @throws \InvalidArgumentException
     * @param \StructType\TripItemResult_v3 $item
     * @return \ArrayType\ArrayOfTripItemResult_v3
     */
    public function addToTripItemResult_v3(\StructType\TripItemResult_v3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripItemResult_v3) {
            throw new \InvalidArgumentException(sprintf('The TripItemResult_v3 property can only contain items of type \StructType\TripItemResult_v3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TripItemResult_v3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TripItemResult_v3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TripItemResult_v3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TripItemResult_v3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TripItemResult_v3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TripItemResult_v3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TripItemResult_v3
     */
    public function getAttributeName()
    {
        return 'TripItemResult_v3';
    }
}
