<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfSubGroup extends AbstractStructArrayBase
{
    /**
     * The SubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubGroup[]
     */
    public $SubGroup;
    /**
     * Constructor method for ArrayOfSubGroup
     * @uses ArrayOfSubGroup::setSubGroup()
     * @param \StructType\SubGroup[] $subGroup
     */
    public function __construct(array $subGroup = array())
    {
        $this
            ->setSubGroup($subGroup);
    }
    /**
     * Get SubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubGroup[]|null
     */
    public function getSubGroup()
    {
        return isset($this->SubGroup) ? $this->SubGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubGroupForArrayConstraintsFromSetSubGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSubGroupSubGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubGroupSubGroupItem instanceof \StructType\SubGroup) {
                $invalidValues[] = is_object($arrayOfSubGroupSubGroupItem) ? get_class($arrayOfSubGroupSubGroupItem) : sprintf('%s(%s)', gettype($arrayOfSubGroupSubGroupItem), var_export($arrayOfSubGroupSubGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubGroup property can only contain items of type \StructType\SubGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroup[] $subGroup
     * @return \ArrayType\ArrayOfSubGroup
     */
    public function setSubGroup(array $subGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($subGroupArrayErrorMessage = self::validateSubGroupForArrayConstraintsFromSetSubGroup($subGroup))) {
            throw new \InvalidArgumentException($subGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($subGroup) || (is_array($subGroup) && empty($subGroup))) {
            unset($this->SubGroup);
        } else {
            $this->SubGroup = $subGroup;
        }
        return $this;
    }
    /**
     * Add item to SubGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroup $item
     * @return \ArrayType\ArrayOfSubGroup
     */
    public function addToSubGroup(\StructType\SubGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubGroup) {
            throw new \InvalidArgumentException(sprintf('The SubGroup property can only contain items of type \StructType\SubGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SubGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SubGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SubGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SubGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SubGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubGroup
     */
    public function getAttributeName()
    {
        return 'SubGroup';
    }
}
