<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoleResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoleResult extends AbstractStructArrayBase
{
    /**
     * The RoleResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoleResult[]
     */
    public $RoleResult;
    /**
     * Constructor method for ArrayOfRoleResult
     * @uses ArrayOfRoleResult::setRoleResult()
     * @param \StructType\RoleResult[] $roleResult
     */
    public function __construct(array $roleResult = array())
    {
        $this
            ->setRoleResult($roleResult);
    }
    /**
     * Get RoleResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoleResult[]|null
     */
    public function getRoleResult()
    {
        return isset($this->RoleResult) ? $this->RoleResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRoleResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoleResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoleResultForArrayConstraintsFromSetRoleResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRoleResultRoleResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoleResultRoleResultItem instanceof \StructType\RoleResult) {
                $invalidValues[] = is_object($arrayOfRoleResultRoleResultItem) ? get_class($arrayOfRoleResultRoleResultItem) : sprintf('%s(%s)', gettype($arrayOfRoleResultRoleResultItem), var_export($arrayOfRoleResultRoleResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoleResult property can only contain items of type \StructType\RoleResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoleResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoleResult[] $roleResult
     * @return \ArrayType\ArrayOfRoleResult
     */
    public function setRoleResult(array $roleResult = array())
    {
        // validation for constraint: array
        if ('' !== ($roleResultArrayErrorMessage = self::validateRoleResultForArrayConstraintsFromSetRoleResult($roleResult))) {
            throw new \InvalidArgumentException($roleResultArrayErrorMessage, __LINE__);
        }
        if (is_null($roleResult) || (is_array($roleResult) && empty($roleResult))) {
            unset($this->RoleResult);
        } else {
            $this->RoleResult = $roleResult;
        }
        return $this;
    }
    /**
     * Add item to RoleResult value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleResult $item
     * @return \ArrayType\ArrayOfRoleResult
     */
    public function addToRoleResult(\StructType\RoleResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoleResult) {
            throw new \InvalidArgumentException(sprintf('The RoleResult property can only contain items of type \StructType\RoleResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoleResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoleResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoleResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoleResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoleResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoleResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoleResult
     */
    public function getAttributeName()
    {
        return 'RoleResult';
    }
}
