<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQuestionPathInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfQuestionPathInfo extends AbstractStructArrayBase
{
    /**
     * The QuestionPathInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QuestionPathInfo[]
     */
    public $QuestionPathInfo;
    /**
     * Constructor method for ArrayOfQuestionPathInfo
     * @uses ArrayOfQuestionPathInfo::setQuestionPathInfo()
     * @param \StructType\QuestionPathInfo[] $questionPathInfo
     */
    public function __construct(array $questionPathInfo = array())
    {
        $this
            ->setQuestionPathInfo($questionPathInfo);
    }
    /**
     * Get QuestionPathInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QuestionPathInfo[]|null
     */
    public function getQuestionPathInfo()
    {
        return isset($this->QuestionPathInfo) ? $this->QuestionPathInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionPathInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionPathInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionPathInfoForArrayConstraintsFromSetQuestionPathInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfQuestionPathInfoQuestionPathInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfQuestionPathInfoQuestionPathInfoItem instanceof \StructType\QuestionPathInfo) {
                $invalidValues[] = is_object($arrayOfQuestionPathInfoQuestionPathInfoItem) ? get_class($arrayOfQuestionPathInfoQuestionPathInfoItem) : sprintf('%s(%s)', gettype($arrayOfQuestionPathInfoQuestionPathInfoItem), var_export($arrayOfQuestionPathInfoQuestionPathInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QuestionPathInfo property can only contain items of type \StructType\QuestionPathInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set QuestionPathInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionPathInfo[] $questionPathInfo
     * @return \ArrayType\ArrayOfQuestionPathInfo
     */
    public function setQuestionPathInfo(array $questionPathInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($questionPathInfoArrayErrorMessage = self::validateQuestionPathInfoForArrayConstraintsFromSetQuestionPathInfo($questionPathInfo))) {
            throw new \InvalidArgumentException($questionPathInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($questionPathInfo) || (is_array($questionPathInfo) && empty($questionPathInfo))) {
            unset($this->QuestionPathInfo);
        } else {
            $this->QuestionPathInfo = $questionPathInfo;
        }
        return $this;
    }
    /**
     * Add item to QuestionPathInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\QuestionPathInfo $item
     * @return \ArrayType\ArrayOfQuestionPathInfo
     */
    public function addToQuestionPathInfo(\StructType\QuestionPathInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuestionPathInfo) {
            throw new \InvalidArgumentException(sprintf('The QuestionPathInfo property can only contain items of type \StructType\QuestionPathInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->QuestionPathInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\QuestionPathInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\QuestionPathInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\QuestionPathInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\QuestionPathInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\QuestionPathInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QuestionPathInfo
     */
    public function getAttributeName()
    {
        return 'QuestionPathInfo';
    }
}
