<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductResult extends AbstractStructArrayBase
{
    /**
     * The ProductResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductResult[]
     */
    public $ProductResult;
    /**
     * Constructor method for ArrayOfProductResult
     * @uses ArrayOfProductResult::setProductResult()
     * @param \StructType\ProductResult[] $productResult
     */
    public function __construct(array $productResult = array())
    {
        $this
            ->setProductResult($productResult);
    }
    /**
     * Get ProductResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductResult[]|null
     */
    public function getProductResult()
    {
        return isset($this->ProductResult) ? $this->ProductResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductResultForArrayConstraintsFromSetProductResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductResultProductResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductResultProductResultItem instanceof \StructType\ProductResult) {
                $invalidValues[] = is_object($arrayOfProductResultProductResultItem) ? get_class($arrayOfProductResultProductResultItem) : sprintf('%s(%s)', gettype($arrayOfProductResultProductResultItem), var_export($arrayOfProductResultProductResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductResult property can only contain items of type \StructType\ProductResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductResult[] $productResult
     * @return \ArrayType\ArrayOfProductResult
     */
    public function setProductResult(array $productResult = array())
    {
        // validation for constraint: array
        if ('' !== ($productResultArrayErrorMessage = self::validateProductResultForArrayConstraintsFromSetProductResult($productResult))) {
            throw new \InvalidArgumentException($productResultArrayErrorMessage, __LINE__);
        }
        if (is_null($productResult) || (is_array($productResult) && empty($productResult))) {
            unset($this->ProductResult);
        } else {
            $this->ProductResult = $productResult;
        }
        return $this;
    }
    /**
     * Add item to ProductResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductResult $item
     * @return \ArrayType\ArrayOfProductResult
     */
    public function addToProductResult(\StructType\ProductResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductResult) {
            throw new \InvalidArgumentException(sprintf('The ProductResult property can only contain items of type \StructType\ProductResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductResult
     */
    public function getAttributeName()
    {
        return 'ProductResult';
    }
}
