<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPoiItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfPoiItem extends AbstractStructArrayBase
{
    /**
     * The PoiItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PoiItem[]
     */
    public $PoiItem;
    /**
     * Constructor method for ArrayOfPoiItem
     * @uses ArrayOfPoiItem::setPoiItem()
     * @param \StructType\PoiItem[] $poiItem
     */
    public function __construct(array $poiItem = array())
    {
        $this
            ->setPoiItem($poiItem);
    }
    /**
     * Get PoiItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PoiItem[]|null
     */
    public function getPoiItem()
    {
        return isset($this->PoiItem) ? $this->PoiItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPoiItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPoiItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoiItemForArrayConstraintsFromSetPoiItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPoiItemPoiItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPoiItemPoiItemItem instanceof \StructType\PoiItem) {
                $invalidValues[] = is_object($arrayOfPoiItemPoiItemItem) ? get_class($arrayOfPoiItemPoiItemItem) : sprintf('%s(%s)', gettype($arrayOfPoiItemPoiItemItem), var_export($arrayOfPoiItemPoiItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PoiItem property can only contain items of type \StructType\PoiItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PoiItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PoiItem[] $poiItem
     * @return \ArrayType\ArrayOfPoiItem
     */
    public function setPoiItem(array $poiItem = array())
    {
        // validation for constraint: array
        if ('' !== ($poiItemArrayErrorMessage = self::validatePoiItemForArrayConstraintsFromSetPoiItem($poiItem))) {
            throw new \InvalidArgumentException($poiItemArrayErrorMessage, __LINE__);
        }
        if (is_null($poiItem) || (is_array($poiItem) && empty($poiItem))) {
            unset($this->PoiItem);
        } else {
            $this->PoiItem = $poiItem;
        }
        return $this;
    }
    /**
     * Add item to PoiItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PoiItem $item
     * @return \ArrayType\ArrayOfPoiItem
     */
    public function addToPoiItem(\StructType\PoiItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PoiItem) {
            throw new \InvalidArgumentException(sprintf('The PoiItem property can only contain items of type \StructType\PoiItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PoiItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PoiItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PoiItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PoiItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PoiItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PoiItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PoiItem
     */
    public function getAttributeName()
    {
        return 'PoiItem';
    }
}
