<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonResult_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonResult_V3 extends AbstractStructArrayBase
{
    /**
     * The PersonResult_V3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonResult_V3[]
     */
    public $PersonResult_V3;
    /**
     * Constructor method for ArrayOfPersonResult_V3
     * @uses ArrayOfPersonResult_V3::setPersonResult_V3()
     * @param \StructType\PersonResult_V3[] $personResult_V3
     */
    public function __construct(array $personResult_V3 = array())
    {
        $this
            ->setPersonResult_V3($personResult_V3);
    }
    /**
     * Get PersonResult_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonResult_V3[]|null
     */
    public function getPersonResult_V3()
    {
        return isset($this->PersonResult_V3) ? $this->PersonResult_V3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonResult_V3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonResult_V3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonResult_V3ForArrayConstraintsFromSetPersonResult_V3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonResult_V3PersonResult_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfPersonResult_V3PersonResult_V3Item instanceof \StructType\PersonResult_V3) {
                $invalidValues[] = is_object($arrayOfPersonResult_V3PersonResult_V3Item) ? get_class($arrayOfPersonResult_V3PersonResult_V3Item) : sprintf('%s(%s)', gettype($arrayOfPersonResult_V3PersonResult_V3Item), var_export($arrayOfPersonResult_V3PersonResult_V3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonResult_V3 property can only contain items of type \StructType\PersonResult_V3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonResult_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V3[] $personResult_V3
     * @return \ArrayType\ArrayOfPersonResult_V3
     */
    public function setPersonResult_V3(array $personResult_V3 = array())
    {
        // validation for constraint: array
        if ('' !== ($personResult_V3ArrayErrorMessage = self::validatePersonResult_V3ForArrayConstraintsFromSetPersonResult_V3($personResult_V3))) {
            throw new \InvalidArgumentException($personResult_V3ArrayErrorMessage, __LINE__);
        }
        if (is_null($personResult_V3) || (is_array($personResult_V3) && empty($personResult_V3))) {
            unset($this->PersonResult_V3);
        } else {
            $this->PersonResult_V3 = $personResult_V3;
        }
        return $this;
    }
    /**
     * Add item to PersonResult_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V3 $item
     * @return \ArrayType\ArrayOfPersonResult_V3
     */
    public function addToPersonResult_V3(\StructType\PersonResult_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonResult_V3) {
            throw new \InvalidArgumentException(sprintf('The PersonResult_V3 property can only contain items of type \StructType\PersonResult_V3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonResult_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonResult_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonResult_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonResult_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonResult_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonResult_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonResult_V3
     */
    public function getAttributeName()
    {
        return 'PersonResult_V3';
    }
}
