<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPOIGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfPOIGroup extends AbstractStructArrayBase
{
    /**
     * The POIGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\POIGroup[]
     */
    public $POIGroup;
    /**
     * Constructor method for ArrayOfPOIGroup
     * @uses ArrayOfPOIGroup::setPOIGroup()
     * @param \StructType\POIGroup[] $pOIGroup
     */
    public function __construct(array $pOIGroup = array())
    {
        $this
            ->setPOIGroup($pOIGroup);
    }
    /**
     * Get POIGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\POIGroup[]|null
     */
    public function getPOIGroup()
    {
        return isset($this->POIGroup) ? $this->POIGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPOIGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPOIGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePOIGroupForArrayConstraintsFromSetPOIGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPOIGroupPOIGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfPOIGroupPOIGroupItem instanceof \StructType\POIGroup) {
                $invalidValues[] = is_object($arrayOfPOIGroupPOIGroupItem) ? get_class($arrayOfPOIGroupPOIGroupItem) : sprintf('%s(%s)', gettype($arrayOfPOIGroupPOIGroupItem), var_export($arrayOfPOIGroupPOIGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The POIGroup property can only contain items of type \StructType\POIGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set POIGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\POIGroup[] $pOIGroup
     * @return \ArrayType\ArrayOfPOIGroup
     */
    public function setPOIGroup(array $pOIGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($pOIGroupArrayErrorMessage = self::validatePOIGroupForArrayConstraintsFromSetPOIGroup($pOIGroup))) {
            throw new \InvalidArgumentException($pOIGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($pOIGroup) || (is_array($pOIGroup) && empty($pOIGroup))) {
            unset($this->POIGroup);
        } else {
            $this->POIGroup = $pOIGroup;
        }
        return $this;
    }
    /**
     * Add item to POIGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\POIGroup $item
     * @return \ArrayType\ArrayOfPOIGroup
     */
    public function addToPOIGroup(\StructType\POIGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\POIGroup) {
            throw new \InvalidArgumentException(sprintf('The POIGroup property can only contain items of type \StructType\POIGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->POIGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\POIGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\POIGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\POIGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\POIGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\POIGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string POIGroup
     */
    public function getAttributeName()
    {
        return 'POIGroup';
    }
}
